<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>H&L Lovin' It | Insights</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="assets/css/foundation.min.css">
    <link rel="stylesheet" type="text/css" href="assets/js/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="assets/js/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="assets/css/styles.css">
    <script type="text/javascript" src="assets/js/jquery.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ScrollMagic/2.0.3/ScrollMagic.js"></script>
    <script type="text/javascript" src="assets/js/animation.gsap.js"></script>
    <script type="text/javascript" src="assets/js/stellar.min.js"></script>
    <script type="text/javascript" src="assets/js/foundation.min.js"></script>
    <script type="text/javascript" src="assets/js/jquery.animateNumber.min.js"></script>
    <script type="text/javascript" src="assets/js/slick/slick.min.js"></script>
    <script type="text/javascript" src="assets/js/app.js"></script>
<style>
.spacer {height:50px}
</style>
</head>
<body>

<?php include_once "header.php"; ?>

<div id="wrapper">
    <div class="row">
      <div class="small-12 columns">
          <h1>H&L PARTNERS</h1>
          <h2>Delivering Insights</h2>
      </div>
    </div>

    <div class="row panel-image">
      <div class="small-12 columns">
          <img src="assets/images/insights-hero-image.jpg"/>
      </div>
    </div>
    <div class="row panel-text pr-3">
        <div class="spacer small-12 columns">&nbsp;
        </div>
      <div class="small-12 columns">
          <div>
              Our core expertise lays in generating and applying insights that drive consumers to McDonald’s.  We are able to garner insights by unifying rich datasets of behavioral, demographic, consumer and advertising data to sales. Leveraging this, we deliver appropriate messaging to the correct audience in the best contexts to maximize store traffic.
          </div>
      </div>
      <div class="spacer small-12 columns">&nbsp;
      </div>
    </div>



    <div class="row panel-slider" style="background-color:#ef664f">
        <div class="row panel-text drink-run2">

          <div class="small-12 columns">
              <div style="color:#fff;">
                  <br clear="all"/>
                  Starting with reporting dashboards on advertising activity to help us identify optimizations and opportunities in real time, we then close the loop by using location based data to attribute advertising exposures to restaurant visits.
              </div>
          </div>
          <div class="small-12 columns">
              <div class="small-0 medium-1 columns"></div>
              <div class="small-12 medium-10 columns" style="padding-bottom:35px;text-align:center;min-height:173;line-height:0">
                  <img src="assets/images/insights-analytics.jpg"/>
              </div>
              <div class="small-0 medium-1 columns"></div>
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
        </div>
    </div>
    <div class="row panel-slider">
        <div class="spacer small-12 columns">&nbsp;
        </div>
        <div class="row panel-text drink-run2">
          <div class="small-12 columns">
              <div>
                  <h3>Insights that are high tech <i>and</i>&nbsp;&nbsp;high touch</h3>
                  <p style="padding-bottom:0">And we drill down further by getting out in to the market to have open and honest conversations with consumers.
<br/><br/>Here’s a recent example from Detroit and Miami to better understand the challenge of gaining trial of the&nbsp;Signature&nbsp;Crafted&nbsp;line.</p>
              </div>
          </div>
      </div>
        <div class="desktop small-0 medium-0 large-2 columns">&nbsp;
        </div>
        <div class="small-12 medium-12 large-8 columns">
            <div class="slider slider-for video1" style="margin-bottom:0;">
                <div class="video">
                    <video id="video1" playsinline poster="assets/images/insights-vid-poster.jpg">
                        <source src="https://player.vimeo.com/external/227448261.hd.mp4?s=a3b52c4fcdba1cf715c734ffa6bdf57e330cb88a&profile_id=175" type="video/mp4">
                    </video>
                </div>
            </div>
        </div>
        <div class="desktop small-0 medium-0 large-2 columns">&nbsp;
        </div>
        <div class="spacer small-12 columns">&nbsp;
        </div>
      </div>
      <div class="row panel-slider" style="background-color:#99c9ca">
          <div class="row panel-text drink-run2">

            <div class="small-12 columns">
                <div>
                    <p style="color:#000;padding-bottom:0">
                        We’ve built a strong reputation within McDonald’s for excellent creative. And it’s because deep, relevant consumer insights result in communications that delivers sales and cash flow.
                    </p>
                </div>
            </div>
          </div>
      </div>

    <section>
        <div class="overlay-white"></div>
        <div class="row overlay-bio">
          <img class="close" src="assets/images/close.png"/>
          <div class="small-12 columns">
              <div class="name-title">
                  <img class="thumbnail" src=""/>
                  <div><span class="name"></span>, <span class="title"></span></div>
              </div>
          </div>
          <div class="small-12 columns">
              <p class="bio"></p>
          </div>
        </div>
    </section>
</div>

<?php include_once "footer.php"; ?>

<script>

$(window).load(function() {
    $('#video1').on('ended',function(){
      $(this).get(0).load();
	  $('.video1 .slick-current').find('.pause-btn').hide();
      $('.video1 .slick-current').find('.play-btn').fadeIn();
    });
});


var controller = new ScrollMagic.Controller();

    var tl = new TimelineLite({paused:true});
    tl.to($(' .line div'), 2, {width:'100%'});
    tl.to($(' .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".pr-3",duration:200})
        .addTo(controller)
        .setTween(tl.play());

    var scene7 = new ScrollMagic.Scene({triggerElement: ".video1"})
        .on('start', function () {
            function isTouchDevice() {
                return 'ontouchstart' in document.documentElement;
            }
            if (isTouchDevice()) {
                $('.video1 .slick-current').find('.play-btn').fadeIn();
            } else {
                $('.video1 .slick-current').children('video').get(0).play();
            }
        })
        .reverse(false)
        .addTo(controller);

    var scene8 = new ScrollMagic.Scene({triggerElement: ".video2"})
        .on('start', function () {
            function isTouchDevice() {
                return 'ontouchstart' in document.documentElement;
            }
            $('.video1 .slick-current').children('video').get(0).pause();
            if (isTouchDevice()) {
                $('.video2 .slick-current').find('.play-btn').fadeIn();
            } else {
                $('.video2 .slick-current').children('video').get(0).play();
            }
        })
        .reverse(false)
        .addTo(controller);

</script>
</body>
</html>
