<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>H&L Lovin' It | Guiding Principles</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="robots" content="noindex, nofollow" />
    <link rel="stylesheet" type="text/css" href="assets/css/foundation.min.css">
    <link rel="stylesheet" type="text/css" href="assets/js/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="assets/js/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="assets/css/styles.css">
    <script type="text/javascript" src="assets/js/jquery.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ScrollMagic/2.0.3/ScrollMagic.js"></script>
    <script type="text/javascript" src="assets/js/animation.gsap.js"></script>
    <script type="text/javascript" src="assets/js/stellar.min.js"></script>
    <script type="text/javascript" src="assets/js/foundation.min.js"></script>
    <script type="text/javascript" src="assets/js/jquery.animateNumber.min.js"></script>
    <script type="text/javascript" src="assets/js/slick/slick.min.js"></script>
    <script type="text/javascript" src="assets/js/app.js"></script>
</head>
<body>

<?php include_once "header.php"; ?>

<div id="wrapper">
    <div class="row">
      <div class="small-12 columns">
          <h1>H&L PARTNERS</h1>
          <h2>Guiding Principles</h2>
      </div>
    </div>
    <div class="row panel-text text-blue">
      <div class="small-12 columns">
          <div>
              The key to our success has been the application of several guiding principles we apply to all McDonald’s markets.
          </div>
      </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns about-us1">
          <img src="assets/images/principles2.jpg"/>
          <p data-stellar-ratio="1.35" data-stellar-offset-parent="true">Build the base.<br/><br/></p>
      </div>
    </div>
    <div class="row panel-text">
      <div class="small-12 columns">
          <div>
              <div class="principles-telescope" style="display:none">
                  <div>
                      <img src="assets/images/principles-telescope1.png"/>
                      <img src="assets/images/principles-telescope2.png"/>
                      <img src="assets/images/principles-telescope3.png"/>
                      <img src="assets/images/principles-telescope4.png"/>
                  </div>
              </div>
              <div class="principles-bricks">
                  <div>
                      <img src="assets/images/principles-brick.png"/>
                      <img src="assets/images/principles-brick.png"/>
                      <img src="assets/images/principles-brick.png"/>
                      <img src="assets/images/principles-brick.png"/>
                      <img src="assets/images/principles-brick.png"/>
                  </div>
              </div>
              <br clear="all"/>
              Focus on long-term baseline building programs versus disjointed tactics and short-term gains.
          </div>
    </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns about-us1">
          <img src="assets/images/principles3b.jpg"/>
          <p data-stellar-ratio="1.35" data-stellar-offset-parent="true">Focus on major opportunities.<br/><br/></p>
      </div>
    </div>
    <div class="row panel-text">
      <div class="small-12 columns">
          <div>
              <div class="principles-glass">
                  <div>
                      <img src="assets/images/principles-glass.jpg"/>
                      <img src="assets/images/principles-exclamation.png"/>
                  </div>
              </div>
              <br clear="all"/>
              Build local strategies around major business opportunities that complement the national plan.
          </div>
      </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns about-us1">
          <img src="assets/images/principles1.jpg"/>
          <p data-stellar-ratio="1.25" data-stellar-offset-parent="true">Keep it simple.<br/></p>
      </div>
    </div>
    <div class="row panel-text">
      <div class="small-12 columns about-us2">
          <div>
              <div class="principles-wheels">
                  <div>
                      <img src="assets/images/principles-wheel1.png"/>
                      <img src="assets/images/principles-wheel2.png"/>
                  </div>
              </div>
              <br clear="all"/>
              Keep marketing plans operationally simple for managers and crew to understand and support. And simple for consumers to embrace.
          </div>
    </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns about-us1">
          <img src="assets/images/principles4.jpg"/>
          <p data-stellar-ratio="1.2" data-stellar-offset-parent="true">Drive profitable guest counts.<br/></p>
      </div>
    </div>
    <div class="row panel-text principles4">
      <div class="small-12 columns">
          <div>
              <div class="principles-arrows" style="display:none">
                  <div>
                      <img src="assets/images/principles-dot.png"/>
                      <img src="assets/images/principles-arrow.png"/>
                      <img src="assets/images/principles-arrow.png"/>
                      <img src="assets/images/principles-arrow.png"/>
                      <img src="assets/images/principles-arrow.png"/>
                  </div>
              </div>
              <div class="principles-drive">
                  <div>
                      <img style="left:0;top:0" src="assets/images/principles-drive1.png"/>
                      <img src="assets/images/principles-drive2.png"/>
                      <div class="white"></div>
                  </div>
              </div>
              <br clear="all"/>
              Focus on the mission to drive guest counts profitably.
          </div>
      </div>
    </div>
</div>

<?php include_once "footer.php"; ?>
<script>
var controller = new ScrollMagic.Controller();

var tl = new TimelineLite({paused:true});
    tl.to($('.principles-wheels img:nth-child(2)'), 2, {rotation:200,ease: Power0.easeNone});
    tl.to($('.principles-wheels img:nth-child(1)'), 2, {rotation:-200,ease: Power0.easeNone},"-=1.95");

var scene = new ScrollMagic.Scene({triggerElement: ".principles-wheels"})
    .addTo(controller)
    .setTween(tl.play());

    /*var tl2 = new TimelineLite({paused:true});
        tl2.to($('.principles-telescope div'), .4, {rotation:0,ease: Power0.easeNone},"-=.4");
    var scene = new ScrollMagic.Scene({triggerElement: ".principles-telescope"})
        .addTo(controller)
        .setTween(tl2.play());*/
    var tl2 = new TimelineLite({paused:true});
        tl2.to($('.principles-bricks img:nth-child(3)'), .3, {'margin-top':0,opacity:1});
        tl2.to($('.principles-bricks img:nth-child(4)'), .3, {'margin-top':0,opacity:1},"-=.2");
        tl2.to($('.principles-bricks img:nth-child(1)'), .3, {'margin-top':0,opacity:1},"-=.2");
        tl2.to($('.principles-bricks img:nth-child(5)'), .3, {'margin-top':0,opacity:1},"-=.2");
        tl2.to($('.principles-bricks img:nth-child(2)'), .3, {'margin-top':0,opacity:1},"-=.2");
    var scene = new ScrollMagic.Scene({triggerElement: ".principles-bricks"})
        .addTo(controller)
        .setTween(tl2.play());

    var tl3 = new TimelineLite({paused:true});
        tl3.to($('.principles-glass img:nth-child(2)'), .4, {scale:1.2});
        tl3.to($('.principles-glass img:nth-child(2)'), .25, {scale:1});

    var scene = new ScrollMagic.Scene({triggerElement: ".principles-glass"})
        .addTo(controller)
        .setTween(tl3.play());

    /*var tl4 = new TimelineLite({paused:true});
        tl4.to($('.principles-arrows img:nth-child(2)'), .65, {scale:1,opacity:1});
        tl4.to($('.principles-arrows img:nth-child(3)'), .65, {scale:1,opacity:1},"-=.65");
        tl4.to($('.principles-arrows img:nth-child(4)'), .65, {scale:1,opacity:1},"-=.65");
        tl4.to($('.principles-arrows img:nth-child(5)'), .65, {scale:1,opacity:1},"-=.65");

    var scene = new ScrollMagic.Scene({triggerElement: ".principles4"})
        .addTo(controller)
        .setTween(tl4.play());*/
    var tl4 = new TimelineLite({paused:true});
        tl4.to($('.principles-drive div .white'), .8, {top:-50,left:50,opacity:1});

    var scene = new ScrollMagic.Scene({triggerElement: ".principles4"})
        .addTo(controller)
        .setTween(tl4.play());
</script>
</body>
</html>
