<?php

//============================================================
// Upload Greenhorn Files
//
// For security, store all docs outside webroot
//============================================================

function greenhorn_upload(){
	$resp = ["errors"=>0, "document"=>"", "doctype"=>"", "messages"=>[]];

	$allowed_file_types = [
		"application/pdf",
		"application/msword",
		"application/vnd.openxmlformats-officedocument.wordprocessingml.document",
		"application/vnd.openxmlformats-officedocument.wordprocessingml.template",
		"application/vnd.ms-word.document.macroEnabled.12",
		"application/vnd.ms-word.template.macroEnabled.12",
		"text/plain",
		"text/richtext"
	];

	if(!function_exists('wp_handle_upload')){
    	require_once(ABSPATH . 'wp-admin/includes/file.php');
	}

	$filekey = "";
	if( isset($_FILES["gh-cover"]) ) $filekey = "gh-cover";
	if( isset($_FILES["gh-resume"]) ) $filekey = "gh-resume";
	if( isset($_FILES["gh-reference"]) ) $filekey = "gh-reference";

	if( !empty($filekey) ){
		if( empty($_FILES[$filekey]['error']) ){
			$uploaded_file_type = $_FILES[$filekey]['type'];
			if( in_array($uploaded_file_type, $allowed_file_types)) {
				$safename = time() . "-" . strtolower( sanitize_file_name($_FILES[$filekey]['name']) );
				
				if( move_uploaded_file($_FILES[$filekey]['tmp_name'],"/home/handlp6/greenhorn/".$safename) ){
					$resp["document"] = $safename;
					$resp["doctype"] = $_FILES[$filekey]['type'];

					$_SESSION[$filekey] = $safename;
					session_commit();

				} else {
					$resp["errors"]++;
					$resp["messages"][] = "Could not save file";
				}

			} else {
				$resp["errors"]++;
				$resp["messages"][] = "Invalid file type";
			}
		} else {
			$resp["errors"]++;
			$resp["messages"][] = "File upload error";
		}
	} else {
		$resp["errors"]++;
		$resp["messages"][] = "Invalid file reference";
	}

	if( !empty($resp["errors"]) && isset($_SESSION[$filekey]) ){
		$resp["document"] = "error";
		$resp["doctype"] = "error";
		$_SESSION[$filekey] = "";
		unset($_SESSION[$filekey]);
		session_commit();
	}

	send_json_response($resp);
}
add_action("wp_ajax_greenhorn_upload", "greenhorn_upload");
add_action("wp_ajax_nopriv_greenhorn_upload", "greenhorn_upload");

//============================================================
// JSON Responder
//============================================================

function send_json_response($data=null){
	header('Content-Type: application/json');
	echo json_encode($data);
	die();
}