<?php
/**
 * Template Name: What We Do - Case Studies
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since H&L Partners 1.0
 */

get_header();
hlp_load_functions("models");

$mode = get_query_var("display_mode");
$slug = get_query_var("case_slug");

if($mode === "list"):
?>

<?php
$banner = types_render_field("banner-image",array("output"=>"raw"));
if(!empty($banner)):
?>
<div id="page-banner" style="background-image:url(<?php echo $banner;?>);"></div>
<?php endif;?>

<div id="page-content" class="row gray">
    <div class="small-12 medium-3 large-3 columns">
        <h2>CASE STUDIES</h2>
    </div>
    <div class="small-12 medium-9 large-9 columns nopadleft">
        <?php
        while(have_posts()): the_post();
            the_content();
        endwhile;
        ?>
    </div>
</div>

<div class="category-row row">
    <div class="small-12 columns">
        <div class="case-category clearfix">
            <div class="case-category-name">Destination Travel</div>
            <div class="case-category-tab"></div>
        </div>
    </div>
</div>

<div id="case-travel" class="case-study-grid row small-up-1 medium-up-2 large-up-3">
    <?php hlp_case_studies("destination-travel",3); ?>
</div>

<div class="category-row row">
    <div class="small-12 columns">
        <div class="case-category clearfix">
            <div class="case-category-name">Retail/Franchise</div>
            <div class="case-category-tab"></div>
        </div>
    </div>
</div>

<div id="case-retail" class="case-study-grid row small-up-1 medium-up-2 large-up-3">
    <?php hlp_case_studies("franchise-retail",3); ?>
</div>

<?php else: ?>

<?php 
	add_filter('the_content','wpautop');
	hlp_case_studies_detail($slug); 
?>

<?php
endif;
get_footer();
