<?php
/**
 * Template Name: Home
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since H&L Partners 1.0
 */

get_header("home");
hlp_load_functions("models");
?>

<section id="home-slider">
    <div id="home-slider-nav">
        <div id="home-slider-dots">
            <ul id="home-slider-dotslist"></ul>
        </div>
    </div>
    <div id="home-slider-frame">
        <div id="home-slider-wrap">
            <?php hlp_home_slides(); ?>
        </div>
    </div>
</section>

<section id="home-groups">
    <div id="home-groups-wrap">
        <div class="row">
			<div class="small-12 medium-6 large-4 columns">
                <a href="/lovinit/" class="home-group">
                    <div class="home-group-photo" style="background-image:url(/wp-content/uploads/2017/04/HOME_SUB_mcd.jpg);"></div>
                    <div class="home-group-card">
                        <div class="home-group-title">McDONALD’S<br/>MARKETING</div>
                        <div class="home-group-info"><p>We have a proven track record for delivering successful, integrated marketing programs from coast to coast.</p></div>
                    </div>
                </a>
            </div>
            <div class="small-12 medium-6 large-4 columns">
                <a href="/what-we-do/franchise-retail/" class="home-group">
                    <div class="home-group-photo" style="background-image:url(/wp-content/uploads/2016/03/HOME_SUB_retail.jpg);"></div>
                    <div class="home-group-card">
                        <div class="home-group-title">Retail/<br/>Franchise</div>
                        <div class="home-group-info"><p>We are specialists in artfully turning a national branding effort into a local or regional sales conversation to close the deal.</p></div>
                    </div>
                </a>
            </div>
            <div class="small-12 medium-6 large-4 columns">
                <a href="/what-we-do/destination-travel/" class="home-group">
                    <div class="home-group-photo" style="background-image:url(/wp-content/uploads/2016/03/HOME_SUB_destination.jpg); background-position:center center;"></div>
                    <div class="home-group-card">
                        <div class="home-group-title">Destination<br/>Travel</div>
                        <div class="home-group-info"><p>We’ve been quietly evolving the art of exploration for decades, inspiring travelers and rewarding clients, to award-winning effect.</p></div>
                    </div>
                </a>
            </div>
            <div class="small-12 medium-6 large-4 columns" style="display:none">
                <a href="/about-us/" class="home-group">
                    <div class="home-group-photo" style="background-image:url(/wp-content/uploads/2016/03/HOME_SUB_about.jpg);"></div>
                    <div class="home-group-card">
                        <div class="home-group-title">About<br/>Us</div>
                        <div class="home-group-info"><p>National in scope and regional in focus, we capitalize on that critical phase of the sale where all the buying triggers converge for your customers.</p></div>
                    </div>
                </a>
            </div>
            <div class="medium-6-push columns hide-for-large"></div>
        </div>
    </div>
</section>

<script>
var SLIDES = {};

jQuery(document).ready(function(){
    jQuery("#home-slider-wrap").on("init",function(slick){
        SLIDES.total = jQuery(".home-slide").length;
        for(var i=0; i<SLIDES.total; i++){
            jQuery("#home-slider-dotslist").append('<li><i class="fa fa-circle-o"></i></li>');
        }
        jQuery("#home-slider-dotslist li").eq(0).html('<i class="fa fa-dot-circle-o"></i>');

        jQuery("#home-slider-dotslist li").on("click",function(){
            var index = jQuery(this).index();
            jQuery("#home-slider-wrap").slick("slickGoTo",index);
        });
    });

    jQuery("#home-slider-wrap").on("afterChange",function(slick,currentSlide){
        var index = jQuery("#home-slider-wrap .slick-active").index();
        jQuery("#home-slider-dotslist li").html('<i class="fa fa-circle-o"></i>');
        jQuery("#home-slider-dotslist li").eq(index).html('<i class="fa fa-dot-circle-o"></i>');
    });

    jQuery("#home-slider-wrap").slick({
        autoplay:true,
        autoplaySpeed: 5000,
        arrows: false,
        dots: false,
        infinite: true,
        fade: true,
        speed: 1000,
        slidesToShow: 1,
        slide: ".home-slide"
    });
});
</script>

<?php
get_footer("home");
