<?php
/**
 * Template Name: What We Do - Services
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since H&L Partners 1.0
 */

get_header();
hlp_load_functions("models");
?>

<?php
$banner = types_render_field("banner-image",array("output"=>"raw"));
if(!empty($banner)):
?>
<div id="page-banner" style="background-image:url(<?php echo $banner;?>);"></div>
<?php endif;?>

<div id="page-content" class="row gray">
    <div class="small-12 medium-3 large-3 columns">
        <h2>SERVICES</h2>
    </div>
    <div class="small-12 medium-9 large-9 columns nopadleft">
        <?php hlp_services(); ?>
    </div>
</div>

<script>
jQuery(document).ready(function(){
    jQuery(".service-title").on("click",function(){
        var index = jQuery(this).index();
        if(!jQuery(this).hasClass("active")){
            jQuery(this).addClass("active");
            jQuery(this).find("i").removeClass("fa-caret-left").addClass("fa-caret-down");
            jQuery(this).parent().find(".service-description").slideDown("fast");
        } else {
            jQuery(this).removeClass("active");
            jQuery(this).find("i").removeClass("fa-caret-down").addClass("fa-caret-left");
            jQuery(this).parent().find(".service-description").slideUp("fast");
        }
    });
});
</script>

<?php get_footer();
