<?php
/**
 * Template Name: What We Do - Viewpoint
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since H&L Partners 1.0
 */

get_header();
hlp_load_functions("models");
?>

<?php
$banner = types_render_field("banner-image",array("output"=>"raw"));
if(!empty($banner)):
?>
<div id="page-banner" style="background-image:url(<?php echo $banner;?>);"></div>
<?php endif;?>

<?php
while(have_posts()):
    the_post();
    the_content();
endwhile;
?>

<div id="gozone-tabs" class="clearfix">
    <div id="gozone-tab-left" class="tablink active">
        <div class="tab">Retail/Franchise</div>
        <div class="tab-tri"></div>
    </div>
    <div id="gozone-tab-right" class="tablink">
        <div class="tab-tri"></div>
        <div class="tab">Destination Travel</div>
    </div>
</div>

<div id="gozone-contents" class="clearfix">
    <div id="gozone-contents-left" class="tabbox">
        <?php hlp_gozone("franchise-retail"); ?>
    </div>
    <div id="gozone-contents-right" class="tabbox" style="display:none">
        <?php hlp_gozone("destination-travel"); ?>
    </div>
</div>

<script>
    jQuery(document).ready(function(){
        jQuery(".tablink").on("click",function(){
            jQuery(".tablink").removeClass("active");
            jQuery(this).addClass("active");
            jQuery(".tabbox").hide();
            jQuery(".tabbox").eq(jQuery(this).index()).fadeIn("fast");
        });
    });
</script>

<?php get_footer();
