<?php
$type = get_post_type();
if($type !== "post") hlp_redirect_404();

add_filter('the_content','wpautop');
get_header("news");

if( have_posts() ): while( have_posts() ): the_post();
$attachment = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
$banner = @$attachment[0];
if(empty($banner)) $banner = "/wp-content/uploads/2016/02/header3.jpg";

$terms = get_the_category($post->ID);
$cats = array();

foreach($terms as $c){
    $cat = get_category($c);
    $cats[] = array('name' => $cat->name,'slug' => $cat->slug);
}

if( empty($cats) || $cats[0]['slug'] === "uncategorized" ) $maincat = "news";
else $maincat = $cats[0]['name'];
?>

<div id="news-nav" class="clearfix">
    <span class="left"><?php previous_post_link('%link','<i class="fa fa-arrow-circle-left"></i> Previous Article'); ?></span>
    <span class="right"><?php next_post_link('%link','Next Article <i class="fa fa-arrow-circle-right"></i>'); ?></span>
</div>

<div id="page-banner" style="background-image:url(<?php echo $banner;?>);"></div>

<div id="news-single" class="clearfix">
    <h1><?php the_title(); ?></h1>
    <div id="news-date"><?php echo get_the_date("m/d/Y"); ?></div>
    <?php the_content(); ?>
</div>

<div id="news-footer" class="clearfix">
    <a href="/news" class="hlbtn back right">Back To News</a>
</div>

<?php
endwhile;
endif;
get_footer();