<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Good Morning</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="../lovinit/assets/css/foundation.min.css">
    <link rel="stylesheet" type="text/css" href="../lovinit/assets/js/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="../lovinit/assets/js/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="../lovinit/assets/css/styles.css">
    <script type="text/javascript" src="../lovinit/assets/js/jquery.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ScrollMagic/2.0.3/ScrollMagic.js"></script>
    <script type="text/javascript" src="../lovinit/assets/js/animation.gsap.js"></script>
    <script type="text/javascript" src="../lovinit/assets/js/stellar.min.js"></script>
    <script type="text/javascript" src="../lovinit/assets/js/foundation.min.js"></script>
    <script type="text/javascript" src="../lovinit/assets/js/jquery.animateNumber.min.js"></script>
    <script type="text/javascript" src="../lovinit/assets/js/slick/slick.min.js"></script>
    <script type="text/javascript" src="assets/js/app.js"></script>
<style>
.spacer {height:50px}
h3 {text-align: center;}
.headline {width:80%;margin-left:10%;text-align: center;padding-top:20px}
.footer-cta {width:100%;font-size:20px !important;text-align:center !important;padding-bottom:20px}
.footer-cta:hover {text-decoration: underline}
@media screen and (max-width:400px) {
    .drink-run2 .line,.drink-run2 .line2 {display: none}
    .slider-nav {margin-left:15%}
}
@media screen and (max-width:350px) {
    .slider-nav {margin-left:10%}
}
</style>
</head>
<body>
<script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');
  ga('create', 'UA-52355104-1', 'auto');
  ga('send', 'pageview');
</script>
    <div id="header">
        <img id="topnav-logo" src="assets/images/handl_logo_blue.jpg"/>
    </div>

<div id="wrapper">
    <div class="row">
      <div class="small-12 columns">
          <h1 class="case-study-h1">MCDONALD’S</h1>
          <h2 class="case-study-h2">Good Morning: A Proven Success!</h2>
      </div>
    </div>
    <div class="row panel-text" style="display:none">
      <div class="small-12 columns">
          <div class='wider'>
              We bring brand McDonald’s to life in local markets, where the community involvement of co-ops at the grassroots level builds brand preference.
          </div>
      </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns">
          <img src="../lovinit/assets/images/goodmorning-casestudy.jpg"/>
      </div>
    </div>
    <div class="row panel-text drink-run2">
      <div class="small-12 columns">
          <div class="wider">
              <div class="impact">
                  <div class="line"><div></div></div>THE CAMPAIGN<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              <p>Consumers told us that a good day begins with a good morning and a good morning begins with good breakfast. The Good Morning campaign is a local, fun and authentic approach to show the passion that McDonald’s has at breakfast. This campaign clearly shows that no one else can serve up a delicious, quality breakfast at a great price with a smile better than McDonald’s. In order to most effectively execute the concept of “Good Morning”, we had to engage the three “Cs” (Customers, Co-op and Crew) with a fully integrated campaign. Enjoy!</p>
          </div>
      </div>
      <div class="spacer small-12 columns">&nbsp;
      </div>
    </div>

    <div class="row panel-slider drink-run3">
        <div class="spacer small-12 columns">&nbsp;
        </div>
        <div class="row">
          <div class="small-12 columns">
              <div>
                  <h3>Authentic, Engaging & Local</h3>
              </div>
          </div>
        </div>
        <div class="spacer small-12 columns">&nbsp;
        </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="medium-12 large-10 columns">
              <div class="slider slider-for slider1">
                    <div class="video" style="text-align:center">
                        <video id="video1" playsinline poster="assets/images/goodmorning-poster-launch.jpg">
                            <source src="https://player.vimeo.com/external/214080661.sd.mp4?s=c612e2ae2a84d409f2d3cfe678208e94b59af362&profile_id=165" type="video/mp4">
                        </video>
                    </div>
                    <div class="video">
                        <video id="video2" playsinline>
                            <source src="https://player.vimeo.com/external/99148030.hd.mp4?s=2dd85ed1c3d63bbf0925bdac045130a09dccbabd&profile_id=113" type="video/mp4">
                        </video>
                    </div>
                    <div class="video">
                        <video playsinline>
                            <source src="https://player.vimeo.com/external/163474182.hd.mp4?s=fa290ee6d5266d083afd7d26f0a35aeb0b85ac91&profile_id=174" type="video/mp4">
                        </video>
                    </div>
                    <div class="video">
                        <video playsinline>
                            <source src="https://player.vimeo.com/external/214079735.hd.mp4?s=ffeabb35f0e8f5f2a2605236bcc97b0b009774c5&profile_id=174" type="video/mp4">
                        </video>
                    </div>
                </div>
                <div class="slider slider-nav slider1-nav">
                    <div><img src="assets/images/goodmorning-thumb-launch.jpg"/><p>Launch Video</p></div>
                    <div><img src="../lovinit/assets/images/CaseStudyPhotos/goodmorning-thumb-mainers.jpg"/><p>Boston Region</p></div>
                    <div><img src="../lovinit/assets/images/CaseStudyPhotos/goodmorning-thumb-bayarea.jpg"/><p>San Fran Co-op</p></div>
                    <div><img src="assets/images/goodmorning-thumb-richmond.jpg"/><p>Richmond Co-op</p></div>
                </div>

          </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
    </div>

    <div class="row panel-slider drink-run3" style="background-color:#99c9ca">
        <div class="spacer small-12 columns">&nbsp;
        </div>
        <div class="row">
          <div class="small-12 columns">
              <div>
                  <h3>Engaging the Crew to Deliver Good Mornings </h3>
                  <p class="headline">Rallying the crew around the idea of delivering breakfast with a smile begins by using real crew members in all the TV commercials. It continues through the use of in-store reminders, activations kits, Co-op incentives and contests. When we deliver a better Good Morning experience in the restaurants, we win. </p>
              </div>
          </div>
        </div>
        <div class="spacer small-12 columns">&nbsp;
        </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="medium-12 large-10 columns">
              <div class="slider slider-for slider2">
                  <div class="image">
                      <img src="assets/images/Crew_1.jpg"/>
                  </div>
                  <div class="image">
                      <img src="assets/images/Crew_2.jpg"/>
                  </div>
                  <div class="image">
                      <img src="assets/images/Crew_3.jpg"/>
                  </div>
                  <div class="image">
                      <img src="assets/images/Crew_4.jpg"/>
                  </div>
                </div>
                <div class="slider slider-nav slider2-nav">
                    <div><img src="assets/images/Crew_1.jpg"/><p>Casting Call</p></div>
                    <div><img src="assets/images/Crew_2.jpg"/><p>Training</p></div>
                    <div><img src="assets/images/Crew_3.jpg"/><p>Crew Shirts</p></div>
                    <div><img src="assets/images/Crew_4.jpg"/><p>Reminders</p></div>
                </div>

          </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
    </div>


    <div class="row panel-slider drink-run3" style="background-color:#fff">
        <div class="spacer small-12 columns">&nbsp;
        </div>
        <div class="row">
          <div class="small-12 columns">
              <div>
                  <h3>An Idea that Translates to All Mediums </h3>
                  <p class="headline">More than just TV commercials, this platform easily extends into other advertising mediums, reinforcing the idea that Good Mornings are our passion.</p>
              </div>
          </div>
        </div>
        <div class="spacer small-12 columns">&nbsp;
        </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="medium-12 large-10 columns">
              <div class="slider slider-for slider3">
                  <div class="video" style="text-align:center">
                      <video id="video3" playsinline poster="assets/images/thumb-medium1.jpg">
                          <source src="https://player.vimeo.com/external/214071743.sd.mp4?s=5e291929f8d47af7d29e1bba995b3538cf97bc58&profile_id=165" type="video/mp4">
                      </video>
                  </div>
                  <div class="image">
                      <img id="img3" src="assets/images/AllMediums-2.jpg"/>
                  </div>
                  <div class="image">
                      <img src="assets/images/AllMediums-3.jpg"/>
                  </div>
                  <div class="image">
                      <img src="assets/images/AllMediums-4.jpg"/>
                  </div>
                  <div class="image">
                      <img src="assets/images/AllMediums-5.jpg"/>
                  </div>
                </div>
                <div class="slider slider-nav slider3-nav" style="margin-left:0">
                    <div><img src="assets/images/thumb-medium1.jpg"/><p>Digital Video</p></div>
                    <div><img src="assets/images/AllMediums-2.jpg"/><p>OOH</p></div>
                    <div><img src="assets/images/AllMediums-3.jpg"/><p>Website</p></div>
                    <div><img src="assets/images/AllMediums-4.jpg"/><p>Digital Ads</p></div>
                    <div><img src="assets/images/AllMediums-5.jpg"/><p>Digital Ads</p></div>
                </div>

          </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
    </div>

    <div class="row panel-slider drink-run3">
        <div class="spacer small-12 columns">&nbsp;
        </div>
        <div class="row">
          <div class="small-12 columns">
              <div>
                  <h3>Consumers Are Lovin’ It</h3>
                  <p class="headline">It’s easy to activate Good Morning visits in your trading area to beat the competition. When the commercials come to life for them they welcome our brand with open arms.</p>
              </div>
          </div>
        </div>
        <div class="spacer small-12 columns">&nbsp;
        </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="medium-12 large-10 columns">
              <div class="slider slider-for slider4">
                  <div class="image">
                      <img src="assets/images/Consumers-2.jpg"/>
                  </div>
                  <div class="gif" data-img="assets/images/Consumers-1.gif">
                      <img src="assets/images/Consumers-1.gif"/>
                  </div>
                  <div class="image">
                      <img src="assets/images/Consumers-3.jpg"/>
                  </div>
                  <div class="gif" data-img="assets/images/Consumers-4.gif">
                      <img src="assets/images/Consumers-4.gif"/>
                  </div>
                </div>
                <div class="slider slider-nav slider4-nav">
                    <div><img src="assets/images/thumb-consumers2.jpg"/><p>Stickers</p></div>
                    <div><img src="assets/images/thumb-consumers1.jpg"/><p>Surprise Visits</p></div>
                    <div><img src="assets/images/thumb-consumers3.jpg"/><p>Social Media</p></div>
                    <div><img src="assets/images/thumb-consumers4.jpg"/><p>Feedback</p></div>
                </div>

          </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
    </div>

      <div class="row panel-text drink-run4 impact-red">
        <div class="small-12 columns">
            <div class="wider">
                <div class="impact impact-red">
                    <div class="line"><div></div></div>IMPACT<div class="line2"><div></div></div>
                </div>
                <br clear="all">
                Good Morning markets have seen the results. They have not only gained visits, sales and profits but have taken market share from formidable competitors like Dunkin’ Donuts in their home market - Boston.
            </div>
            <div class="spacer small-12 columns">&nbsp;
            </div>
            <div class="small-12 columns">
                <img src="assets/images/graph.jpg"/>
            </div>
            <div class="spacer small-12 columns">&nbsp;
            </div>
        </div>
      </div>
      <div class="row panel-text drink-run4">
          <div class="spacer small-12 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
        <div class="small-12 columns">
            <div class="wider">
                <h3>More Affordable Than You Think</h3>
                <p style="font-size:20px">Good Morning has been executed in over 1,100 restaurants with more joining in 2017. From the entire Boston Region to Co-ops with 25 restaurants, the investment in the larger idea and insight has paid off. Working with your local agency, your budget can afford a version of the campaign that meets your needs and drives your business as it has done in all of the markets to date.</p>
                <p style="font-size:20px">Every Co-op spends hundreds of thousands of dollars in media. The Good Morning campaign is an investment that builds to engage your customers and crew to deliver Good Morning profits.</p>
            </div>
            <div class="spacer small-12 columns">&nbsp;
            </div>
            <div class="spacer small-12 columns">&nbsp;
            </div>
        </div>
      </div>

</div>

<section id="footer">
	<div class="row" style="padding-top:30px">
	  <div class="homepage-box small-12 columns">
          <p class="footer-cta"><a href="../lovinit">Learn even more about our McDonald’s Expertise Here »</a></p>
		<p><span style="color:#2b2727;font-size:29px">CONTACT</span><br/>
			<span style="color:#fff;font-size:23px;line-height: 160%;">TYLER MARTIN</span><br/>
			SVP, H&L PARTNERS<br/>
			<span id="tyler-phone"></span> | <span id="tyler-email"></span>
		</p>
		<br clear="all"/>
		<ul id="offices">
			<li>LEXINGTON</li>
			<li>CHARLOTTE</li>
			<li>RICHMOND</li>
			<li>BOSTON</li>
			<li>ST. LOUIS</li>
			<li>SAN FRANCISCO</li>
		</ul>
		<br clear="all"/>
		<div id="border"></div>
		<br clear="all"/>
		<p id="copyright">&copy; Copyright H&L Partners Advertising. All Rights Reserved.</p>
        <p class="footer-cta"><a href="assets/GoodMorningPlatform.pdf">Download Presentation</a></p>
	</div>
  </div>
</section>

<script>
$( "#tyler-email" ).html( "<a href='mailto:tmartin@handlpartners.com'>tmartin@handlpartners.com</a>" );
$( "#tyler-phone" ).html( "314-4975660" );

$(window).load(function() {
    $(window).on('resize', function(){
        $('#video1').css({height:$('#video2').css('height'),width:'auto'});
        $('#video3').css({height:$('#img3').css('height'),width:'auto'});
    });
    $('#video1').css({height:$('#video2').css('height'),width:'auto'});
    $('#video3').css({height:$('#img3').css('height'),width:'auto'});
});

var controller = new ScrollMagic.Controller();

    var tl = new TimelineLite({paused:true});
    tl.to($('.drink-run2 .line div'), 2, {width:'100%'});
    tl.to($('.drink-run2 .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run2",duration:200})
        .addTo(controller)
        .setTween(tl.play());

    var tl2 = new TimelineLite({paused:true});
    tl2.to($('.drink-run4 .line div'), 2, {width:'100%'});
    tl2.to($('.drink-run4 .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run4",duration:200})
        .addTo(controller)
        .setTween(tl2.play());

    var scene7 = new ScrollMagic.Scene({triggerElement: ".slider1"})
        .on('start', function () {
            function isTouchDevice() {
                return 'ontouchstart' in document.documentElement;
            }
            if (isTouchDevice()) {
                $('.slider1 .slick-current').find('.play-btn').fadeIn();
            } else {
                $('.slider1 .slick-current').children('video').get(0).play();
            }
        })
        .reverse(false)
        .addTo(controller);

    var scene8 = new ScrollMagic.Scene({triggerElement: ".slider3"})
        .on('start', function () {
            function isTouchDevice() {
                return 'ontouchstart' in document.documentElement;
            }
            $('.slider1 .slick-current').children('video').get(0).pause();
            $('.slider1 .slick-current').find('.play-btn').fadeIn();

            if (isTouchDevice()) {
                $('.slider3 .slick-current').find('.play-btn').fadeIn();
            } else {
                $('.slider3 .slick-current').children('video').get(0).play();
            }
        })
        .reverse(false)
        .addTo(controller);

</script>
</body>
</html>
