<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>H&L Lovin' It | Good Morning</title>
    <meta name="description" content="">
	<meta name="robots" content="noindex, nofollow" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="../assets/css/foundation.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/js/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="../assets/js/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/styles.css">
    <script type="text/javascript" src="../assets/js/jquery.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ScrollMagic/2.0.3/ScrollMagic.js"></script>
    <script type="text/javascript" src="../assets/js/animation.gsap.js"></script>
    <script type="text/javascript" src="../assets/js/stellar.min.js"></script>
    <script type="text/javascript" src="../assets/js/foundation.min.js"></script>
    <script type="text/javascript" src="../assets/js/jquery.animateNumber.min.js"></script>
    <script type="text/javascript" src="../assets/js/app.js"></script>
    <script type="text/javascript" src="../assets/js/slick/slick.min.js"></script>
</head>
<body>

<?php include_once "../header.php"; ?>

<div id="wrapper">
    <div class="row">
      <div class="small-12 columns">
          <h1 class="case-study-h1">MCDONALD'S</h1>
          <h2  class="case-study-h2">Good Morning</h2>
      </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns drink-run1">
          <img src="../assets/images/goodmorning-casestudy.jpg"/>
      </div>
    </div>
    <div class="row panel-text drink-run2">
      <div class="small-12 columns">
          <div>
              <div class="impact">
                  <div class="line"><div></div></div>THE OPPORTUNITY<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              Owning the “Good” in Good Morning
              <p>Consumers give McDonald's high marks for our breakfast food and service, but local marketing has historically been limited to promoting an item at a price. The bigger opportunity is for McDonald’s to own the optimism, and the “good”, consumers feel in morning and take it to the streets in our local markets.</p>
          </div>
      </div>
    </div>
    <div class="row panel-slider drink-run3">
        <div class="spacer small-12 columns">&nbsp;
        </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="medium-12 large-10 columns">
              <div class="slider slider-for">
					<div class="video">
                        <video playsinline poster="../assets/images/CaseStudyPhotos/goodmorning-thumb-bayarea.jpg">
                            <source src="https://player.vimeo.com/external/163474182.hd.mp4?s=fa290ee6d5266d083afd7d26f0a35aeb0b85ac91&profile_id=174" type="video/mp4">
                        </video>
                	</div>
                    <div class="image">
                        <img src="../assets/images/CaseStudyPhotos/GoodMorning-OOH.jpg"/>
                	</div>
                    <div class="video">
                        <video playsinline>
                            <source src="https://player.vimeo.com/external/99148030.hd.mp4?s=2dd85ed1c3d63bbf0925bdac045130a09dccbabd&profile_id=113" type="video/mp4">
                        </video>
                    </div>
                    <div class="image">
                        <img src="../assets/images/CaseStudyPhotos/GoodMorning-website.jpg"/>
                    </div>
                    <div class="video">
                        <video playsinline>
                            <source src="https://player.vimeo.com/external/62616384.hd.mp4?s=f576acd5b5167d7ab2d7283e36a83900d8e53a52&profile_id=113" type="video/mp4">
                        </video>
                    </div>
				</div>
				<div class="slider slider-nav">
                    <div><img src="../assets/images/CaseStudyPhotos/goodmorning-thumb-bayarea.jpg"/><p>TV</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/GoodMorning-OOH.jpg"/><p>OOH</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/goodmorning-thumb-mainers.jpg"/><p>TV</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/GoodMorning-website.jpg"/><p>Digital</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/goodmorning-thumb-escalator.jpg"/><p>TV</p></div>
				</div>

          </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
    </div>
    <div class="row panel-text drink-run4 impact-red">
      <div class="small-12 columns">
          <div class="wider">
              <div class="impact impact-red">
                  <div class="line"><div></div></div>IMPACT<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              <p>Based on positive market results, having built baseline breakfast sales, the Good Morning campaign has been replicated across markets around the US system.</p>
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
      </div>
    </div>
</div>

<?php include_once "../footer.php"; ?>
<script>

var controller = new ScrollMagic.Controller();

    var tl = new TimelineLite({paused:true});
    tl.to($('.drink-run2 .line div'), 2, {width:'100%'});
    tl.to($('.drink-run2 .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run2",duration:200})
        .addTo(controller)
        .setTween(tl.play());

    var tl2 = new TimelineLite({paused:true});
    tl2.to($('.drink-run4 .line div'), 2, {width:'100%'});
    tl2.to($('.drink-run4 .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run4",duration:200})
        .addTo(controller)
        .setTween(tl2.play());

    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run4"})
        .on('start', function () {
            $('#threehundred').prop('number', 200).animateNumber({ number: 300 },1000);
        })
        .reverse(false)
        .addTo(controller);

        var scene7 = new ScrollMagic.Scene({triggerElement: ".slider-for"})
            .on('start', function () {
                function isTouchDevice() {
                    return 'ontouchstart' in document.documentElement;
                }
                if (isTouchDevice()) {
                    $('.slider-for .slick-current').find('.play-btn').fadeIn();
                } else {
                    $('.slider-for .slick-current').children('video').get(0).play();
                }
            })
            .reverse(false)
            .addTo(controller);
</script>
</body>
</html>
