<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>H&L Lovin' It | Agency Philosophy</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="assets/css/foundation.min.css">
    <link rel="stylesheet" type="text/css" href="assets/js/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="assets/js/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="assets/css/styles.css">
    <script type="text/javascript" src="assets/js/jquery.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ScrollMagic/2.0.3/ScrollMagic.js"></script>
    <script type="text/javascript" src="assets/js/animation.gsap.js"></script>
    <script type="text/javascript" src="assets/js/stellar.min.js"></script>
    <script type="text/javascript" src="assets/js/foundation.min.js"></script>
    <script type="text/javascript" src="assets/js/jquery.animateNumber.min.js"></script>
    <script type="text/javascript" src="assets/js/slick/slick.min.js"></script>
    <script type="text/javascript" src="assets/js/app.js"></script>
</head>
<body>

<?php include_once "header.php"; ?>

<div id="wrapper">
    <div class="row">
      <div class="small-12 columns">
          <h1>H&L PARTNERS</h1>
          <h2>Agency Philosophy</h2>
      </div>
    </div>
    <div class="row panel-text text-blue">
        <div class="spacer small-12 columns">&nbsp;
        </div>
      <div class="small-12 columns">
          <div>
              The key to our success working toward Vision 20/20 will be the effective application of Performance Based Marketing – the agency philosophy we apply to all McDonald’s markets. The premise behind Performance Based Marketing is that there are ways to market that are prudent and efficient, and ways that are wasteful and inefficient. Our objective is to squeeze the greatest Return from your Marketing Investment.
          </div>
      </div>
      <div class="spacer small-12 columns">&nbsp;
      </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns about-us1">
          <img src="assets/images/principles2.jpg"/>
          <p data-stellar-ratio="1.35" data-stellar-offset-parent="true">Build the Base.<br/><br/></p>
      </div>
    </div>
    <div class="row panel-text text-red">
        <div class="spacer small-12 columns">&nbsp;
        </div>
      <div class="small-12 columns">
          <div>
             Focus on long-term baseline building programs versus random tactics and short-term gains.  A six week jolt of positive comp sales feels great, but if we invest our resources in short-term, disjointed initiatives that don’t contribute to baseline growth – we’re simply running in place.
          </div>
      </div>
      <div class="spacer small-12 columns">&nbsp;
      </div>
    </div>
    <div class="row panel-text">
      <div class="small-12 columns">
          <div>
              <div class="principles-arrows" style="display:none">
                  <div>
                      <img src="assets/images/principles-dot.png"/>
                      <img src="assets/images/principles-arrow.png"/>
                      <img src="assets/images/principles-arrow.png"/>
                      <img src="assets/images/principles-arrow.png"/>
                      <img src="assets/images/principles-arrow.png"/>
                  </div>
              </div>
              <div class="principles-drive">
                  <div>
                      <img style="left:0;top:0" src="assets/images/principles-drive1.png"/>
                      <img src="assets/images/principles-drive2.png"/>
                      <div class="white"></div>
                  </div>
              </div>
              <br clear="all"/>
              Focus on the Heavy User to drive Profitable Guest Counts.
          </div>
          <p class="philosophy-p">We create marketing programs to motivate the heavy-using, high-yield QSR customer, as our mission is to drive Guest Counts profitably. Most marketers define the target consumer in demographic terms (e.g., young adults 18-34).  We define the target primarily in terms of category usage.</p>
          <p class="philosophy-p"><img src="assets/images/philosophy-ProfitContribution.png" style="max-width:1000px"/></p>
          <p class="philosophy-p">Even though some customers bring much less profit potential, the cost to market to them can be the same to reach your high-yield customer.  Our plans not only focus the media strategy to the Heavy User, but our creative messaging is developed according to their needs and perspectives.</p>
       </div>

    </div>

    <div class="row panel-image">
      <div class="small-12 columns about-us1">
          <img src="assets/images/principles3b.jpg"/>
          <p data-stellar-ratio="1.35" data-stellar-offset-parent="true">Focus on major opportunities.<br/><br/></p>
      </div>
    </div>
    <div class="row panel-text">
      <div class="small-12 columns">
          <div>
              <div class="principles-glass">
                  <div>
                      <img src="assets/images/principles-glass.jpg"/>
                      <img src="assets/images/principles-exclamation.png"/>
                  </div>
              </div>
              <br clear="all"/>
              Build local strategies around major business opportunities that complement the national plan.
          </div>
          <p class="philosophy-p">Breakfast presents a significant local opportunity, but how we grow breakfast varies widely, market to market. For example, in New England baked goods consumption is nearly twice the US average, and in Southern markets biscuits drive breakfast. Tactics vary, but our marketing focus addresses the larger opportunity at breakfast.</p>
          <p class="philosophy-p" style="display:none">Big opportunities can seem daunting, but the returns can be significant.  For example, in New England, baked goods consumption is nearly twice the US average, and taking on Dunk’in Donuts is a challenge.  But we’re now in the market with a great product line and focused marketing support.</p>
      </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns about-us1">
          <img src="assets/images/principles1.jpg"/>
          <p data-stellar-ratio="1.25" data-stellar-offset-parent="true">Keep it simple.<br/></p>
      </div>
    </div>
    <div class="row panel-text">
      <div class="small-12 columns about-us2">
          <div>
              <div class="principles-wheels">
                  <div>
                      <img src="assets/images/principles-wheel1.png"/>
                      <img src="assets/images/principles-wheel2.png"/>
                  </div>
              </div>
              <br clear="all"/>
              Keep marketing plans operationally simple for managers and crew to understand and support. And simple for consumers to embrace.
          </div>
          <p class="philosophy-p">If marketing ideas can’t be executed well at the restaurant level, we risk harming our business. </p>
    </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns about-us1">
          <img src="assets/images/principles4.jpg"/>
      </div>
    </div>

</div>

<?php include_once "footer.php"; ?>
<script>
var controller = new ScrollMagic.Controller();

var tl = new TimelineLite({paused:true});
    tl.to($('.principles-wheels img:nth-child(2)'), 2, {rotation:200,ease: Power0.easeNone});
    tl.to($('.principles-wheels img:nth-child(1)'), 2, {rotation:-200,ease: Power0.easeNone},"-=1.95");

var scene = new ScrollMagic.Scene({triggerElement: ".principles-wheels"})
    .addTo(controller)
    .setTween(tl.play());


    var tl2 = new TimelineLite({paused:true});
        tl2.to($('.principles-bricks img:nth-child(3)'), .3, {'margin-top':0,opacity:1});
        tl2.to($('.principles-bricks img:nth-child(4)'), .3, {'margin-top':0,opacity:1},"-=.2");
        tl2.to($('.principles-bricks img:nth-child(1)'), .3, {'margin-top':0,opacity:1},"-=.2");
        tl2.to($('.principles-bricks img:nth-child(5)'), .3, {'margin-top':0,opacity:1},"-=.2");
        tl2.to($('.principles-bricks img:nth-child(2)'), .3, {'margin-top':0,opacity:1},"-=.2");
    var scene = new ScrollMagic.Scene({triggerElement: ".principles-bricks"})
        .addTo(controller)
        .setTween(tl2.play());

    var tl3 = new TimelineLite({paused:true});
        tl3.to($('.principles-glass img:nth-child(2)'), .4, {scale:1.2});
        tl3.to($('.principles-glass img:nth-child(2)'), .25, {scale:1});

    var scene = new ScrollMagic.Scene({triggerElement: ".principles-glass"})
        .addTo(controller)
        .setTween(tl3.play());


    var tl4 = new TimelineLite({paused:true});
        tl4.to($('.principles-drive div .white'), .8, {top:-50,left:50,opacity:1});

    var scene = new ScrollMagic.Scene({triggerElement: ".principles-drive"})
        .addTo(controller)
        .setTween(tl4.play());
</script>
</body>
</html>
