<div id="case-study">
	
	<div id="case-study-nav">
		<a href="<?php echo base_url();?>agency/case-studies/meeting-guru">Previous</a>
		&nbsp;|&nbsp;
		<a href="<?php echo base_url();?>agency/case-studies/stl-cvc-branding">Next</a>
	</div>
	
	<h1>Missouri Tourism</h1>
	<h2>Branding Campaign</h2>
	
	<div class="break"></div>
	
	<h3>Background</h3>
	
	<p>For decades, the Missouri Division of Tourism frequently changed their ad campaigns and brand taglines. As 
	the result, the state lacked long-term brand equity as a travel destination. At the same time today’s competitive 
	travel market challenged Missouri to break out from the Midwestern pack as a unique, surprising vacation destination.</p>
	
	<p>The solution was to develop a new Missouri brand (logo, tagline, and campaign) that would differentiate 
	Missouri and provide the state with a consistent, durable and resonant tourism message.</p>
	
	<h3>The Creative Challenge</h3>
	
	<p>In order to rebrand Missouri Tourism, we had to understand existing consumer impressions of Missouri. 
	Through extensive brand personality research, we learned that consumers did not have negative connotations of 
	Missouri, but on the other hand, they weren’t sure what Missouri stood for either.</p>
	
	<p>This research afforded us a blank slate to develop a campaign. After in-depth creative message testing, 
	we set out to own the concept of variety. While many states can tout great tourism assets, variety was a 
	unique position that no other states had touched as a brand cornerstone. From lakes and state parks to wine 
	country, urban nightlife and scuba adventures, Missouri is a state of variety that exceeds expectation.</p>
	
	<h3>The Execution</h3>
	
	<p>During the creative process, 109 taglines and 80 logos were developed to ultimately arrive at Missouri 
	Division of Tourism’s new brand campaign in the spring of 2013- “Missouri: Enjoy the Show.” The new tagline 
	capitalized on consumers’ familiarity with Missouri and their “Show-Me State” nickname, building top-of-mind 
	awareness. The new tagline also encouraged visitors to consider the variety of Missouri tourism experiences 
	available – from small towns and urban destinations to outdoor activities and world-class arts and culture.</p>
	
	<p><strong>Paid Media:</strong> Seven TV spots, seven billboards and seven print ads in addition to online 
	and mobile banners were placed in Missouri’s target markets. Broadening the campaign even further, we 
	launched a cost-efficient transit campaign in Chicago, one of our key opportunity markets. By wrapping 
	full train cars with compelling Missouri imagery of lakes, wineries and outdoor adventures, we aimed to 
	transport transit riders from the 9-5 grind and put them in a vacation state of mind.</p>
	
	<p><strong>Owned Media:</strong> The brand launch was also supported by a full design refresh of the 
	consumer-facing digital assets, VisitMO.com, the VisitMO Spotlight blog, and the Discover MO e-newsletter. 
	News.VisitMO.com, the news site for industry and press members, also received a creative refresh.</p>
	
	<p><strong>Social:</strong> To support Missouri’s robust suite of social media channels, a combination 
	of content planning, influencer marketing and strategic paid media placements promoted Missouri as an 
	exciting destination packed with variety. The Facebook campaign included new creative revealing some of 
	Missouri’s treasured destinations along with a paid media buy. An influencer marketing program included 
	sponsored blog posts and tweets and contributed recommendations from actual consumers about Missouri’s 
	variety. Pre-roll videos ran on various networks including YouTube to showcase the gorgeous new TV spots.</p>
	
	<h3>Results</h3>
	
	<p>The brand launch was received positively by consumers and industry members alike. Research will be 
	conducted in the Fall to determine advertising effectiveness and intent to travel among our target audience. 
	However, preliminary results have been strong. Missouri Tourism social channels have marked significant 
	increases in followers and brand engagement and continue to grow. The Facebook fan base increased by 
	approximately 43%, as did Twitter by 8%. YouTube views were through the roof at hundreds of thousands 
	of views and counting. VisitMO website traffic increased, as did “Order Your Travel Guide” hits over year 
	prior. E-newsletter click-throughs also increased, performing well above industry average. Banner ads 
	also ranked above industry average, at nearly a .18% click through. Economic impact and ROI data will 
	be available in January 2014. In the meantime, why don’t you come to Missouri and enjoy the show?</p>
	
	<h3 class="red">TV Spots</h3>
	
	<div id="gallery3" class="case-study-gallery">
		<a href="http://vimeo.com/66860551"><img src="<?php echo base_url();?>assets/img/gallery/visitmo-vid1.jpg" /></a>
		<a href="http://vimeo.com/66860735"><img src="<?php echo base_url();?>assets/img/gallery/visitmo-vid2.jpg" /></a>
		<a href="http://vimeo.com/66860548"><img src="<?php echo base_url();?>assets/img/gallery/visitmo-vid3.jpg" /></a>
		<a href="http://vimeo.com/66860552"><img src="<?php echo base_url();?>assets/img/gallery/visitmo-vid4.jpg" /></a>
		<a href="http://vimeo.com/66860550"><img src="<?php echo base_url();?>assets/img/gallery/visitmo-vid5.jpg" /></a>
		<a href="http://vimeo.com/66860549"><img src="<?php echo base_url();?>assets/img/gallery/visitmo-vid6.jpg" /></a>
		<a href="http://vimeo.com/66860736"><img src="<?php echo base_url();?>assets/img/gallery/visitmo-vid7.jpg" /></a>
	</div>
	
	<h3 class="red">Print</h3>

	<div id="gallery1" class="case-study-gallery">
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-print1.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-print2.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-print3.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-print4.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-print5.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-print6.jpg" />
	</div>

	<h3 class="red">Transit</h3>

	<div id="gallery2" class="case-study-gallery">
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-outdoor1.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-outdoor3.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-outdoor4.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-outdoor5.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-outdoor6.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-outdoor7.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-outdoor10.jpg" />
		<img src="<?php echo base_url();?>assets/img/visitmo/branding-outdoor11.jpg" />
	</div>
	
</div>

<!-- INIT GALLERIA //-->
<script>
	Galleria.loadTheme('<?php echo base_url();?>assets/galleria/themes/classic/galleria.classic.min.js');
    Galleria.run('#gallery1');
    Galleria.run('#gallery2');
    Galleria.run('#gallery3');
</script>