<div id="case-study">
	<div id="case-study-nav">
		<a href="<?php echo base_url();?>agency/case-studies/awards">Previous</a>
		&nbsp;|&nbsp;
		<a href="<?php echo base_url();?>agency/case-studies/visitmo-branding">Next</a>
	</div>
	
	<h1>St. Louis CVC</h1>
	<h2>Meeting Guru</h2>
	
	<div class="break"></div>
	
	<h3>Background</h3>
	
	<p>With the urban renaissance St. Louis had experienced over the past decade, they wanted to prove the notion that "seeing is believing." 
	The St. Louis CVC sales and marketing team successfully pitched and secured the "Super Bowl of Meetings”: the American Society of 
	Association Executives (ASAE) 2011 Annual Meeting &amp; Exposition, as well as the Meeting Planners International (MPI) 2012 global congress meeting</p>
	
	<p>This "double header" of the two most important meeting planner events gave the St. Louis CVC a unique opportunity to showcase our city to a 
	combined 7,500 meeting decision-makers.</p>
	
	<h3>Marketing Challenge</h3>
	
	<p>We needed to create awareness of St. Louis as a meeting and convention destination for associations. Our goal was not only to promote the meeting 
	venues, but also to create excitement about the world-class attractions and, perhaps most significantly, increase attendance at both the ASAE and 
	MPI meetings. Truth be told, we were worried that the meeting planners would skip the meeting in St. Louis due to poor perceptions of the city.</p>
	
	<p>To accomplish this, we needed a campaign that was unique, engaging and not necessarily recognizable as St. Louis at first glance. We wanted to 
	compel the audience to find out more, register for the meeting and be pleasantly surprised by what they discovered once they got to St. Louis.</p>
	
	<h3>The Creation of The Meeting Guru</h3>
	
	<p>We developed a creative concept that could be applied to both events. The idea was simple: we introduced <strong>"The Meeting Guru,"</strong> a lovable but 
	slightly overzealous character who’s debuting his brand new book, billed as "The Quintessential Guide To Successful Events." It was an offbeat 
	approach in which consumers weren’t given a straightforward sell. Rather, through The Guru’s clever lines and videos, the message eventually became 
	crystal clear.</p>
	
	<p>We decided to utilize the ASAE’s Springtime Expo in Washington D.C. as a launching point for our campaign to promote the upcoming Annual Meeting 
	&amp; Exposition in St. Louis.</p>
	
	<p>Several media platforms were chosen for campaign exposure, making use of on-site appearances and signage at the Springtime Expo, as well as a 
	2-week mass transit station takeover at the Washington D.C. Mt. Vernon/Convention Center Metro stop.</p>
	
	<p>Through the mass transit takeover, in-person appearances, e-blasts, posters and more, meeting planners and meeting attendees were driven to the 
	Guru’s website, <a href="http://themeetingguru.com">TheMeetingGuru.com</a>, where visitors could hear him give his tips and tricks to planning the perfect 
	event, which oh-so-coincidentally has everything to do with having it in St. Louis.</p>
	
	<p>Once at the web site, they are welcomed to watch his "Speaker Series," in which—surprise, surprise—St. Louis emerges as the perfect city for 
	your next meeting. With chapters such as, "Cosmo Without the Clutter", The Guru gets his points across in a one-of-a-kind lecture. Visitors are 
	also invited to purchase his (always sold-out) book and otherwise bask in his vast knowledge.</p>
	
	<p>On-site at the ASAE Expo, the Meeting Guru met with the masses, passed out business cards, and doled out some of his famous one-liners, such 
	as “If you knew what I know, you wouldn’t need my book” and "My book is like fishing with dynamite in a barrel."</p>
	
	<p>Attendees also saw his likeness in three separate print ads in the show daily. As a follow-up, there were several Meeting Guru email blasts 
	that thanked attendees, and encouraged them to read more about The Guru’s knowledge.</p>
	
	<p>For Meeting Planners International (MPI), we filmed the Meeting Guru speaking about a number of familiar topics to meeting-goers, but in 
	settings that they might find a little unfamiliar.</p>
	
	<p>In one video, the Guru’s robot assistant helps him as he discusses how technology can enhance your event as a meeting planner. In another, 
	the Guru relaxes in the sauna in a towel as he enlightens viewers about international issues and how they affect your business. All of the 
	videos enticed viewers to register for the MPI and attend to learn even more about these important convention issues.</p>
	
	<h3>Results</h3>
	
	<p>The quantifiable goal was to increase attendance to ASAE Annual Meeting and MPI global congress. The soft goal was to position St. Louis 
	as an innovative, creative destination worthy of consideration for future meetings.</p>
	
	<p>The Meeting Guru was the talk of the ASAE Expo and the MPI congress. Between his page views, one-on-one personal interactions, interviews, 
	JumboTron appearances, and grand prize giveaway, he connected with thousands of his prime audience.</p>
	
	<p>According to ASAE figures, delegates spent an estimated $5.7 million in the St. Louis region during their stay with a projected 20 percent 
	of the executives in attendance expected to book their own meetings in St. Louis over the next five years.</p>
	
	<p>1. St. Louis drove higher attendance (5,368) than the past two cities ASAE’s annual meeting has been held in (Toronto and LA).</p>
	
	<p>2. St. Louis hosted more than 1,100 ASAE delegates at their booth during the Expo.</p>
	
	<p>3. Over 2,500 delegates attended the MPI congress, the highest attendance ever for this event.</p>

	<p>4. 92% of ASAE attendees rated their St. Louis experience above average or outstanding</p>
	
	<p>5. The estimated economic impact of future bookings as a result of hosting ASAE is $185.5 million</p>
	
	<p>Given a total budget of $100,000 for media and production for both events, the agency successfully delivered a significant marketing ROI to 
	the St. Louis CVC, and had a lot of fun along the way.</p>

	<h3 class="red">Case Study</h3>
	
	<div id="gallery3" class="case-study-gallery">
		<a href="http://vimeo.com/47039477"><img src="<?php echo base_url();?>assets/img/gallery/guru-vidstudy1.jpg" /></a>
	</div>
	
	<h3 class="red">Online Videos</h3>

	<div id="gallery2" class="case-study-gallery">
		<a href="http://www.youtube.com/watch?v=pPzFP-Fg04Y"><img src="<?php echo base_url();?>assets/img/gallery/guru-vid1.jpg" /></a>
		<a href="http://www.youtube.com/watch?v=KcP6orIWaW4"><img src="<?php echo base_url();?>assets/img/gallery/guru-vid2.jpg" /></a>
		<a href="http://www.youtube.com/watch?v=0-_0j7lgnxY"><img src="<?php echo base_url();?>assets/img/gallery/guru-vid3.jpg" /></a>
		<a href="http://www.youtube.com/watch?v=89p3qHUCpbI"><img src="<?php echo base_url();?>assets/img/gallery/guru-vid4.jpg" /></a>
		<a href="http://www.youtube.com/watch?v=qV8Ql2QYFBE"><img src="<?php echo base_url();?>assets/img/gallery/guru-vid5.jpg" /></a>
        <a href="http://www.youtube.com/watch?v=15BAdL6v5uY"><img src="<?php echo base_url();?>assets/img/gallery/guru-vid6.jpg" /></a>
	</div>
	
	<h3 class="red">Transit</h3>

	<div id="gallery1" class="case-study-gallery-portrait">
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img10.jpg" />
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img11.jpg" />
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img12.jpg" />
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img1.jpg" />
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img2.jpg" />
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img3.jpg" />
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img4.jpg" />
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img5.jpg" />
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img6.jpg" />
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img7.jpg" />
        <img src="<?php echo base_url();?>assets/img/gallery/guru-img8.jpg" />
		<img src="<?php echo base_url();?>assets/img/gallery/guru-img9.jpg" />
	</div>
	
</div>

<!-- INIT GALLERIA //-->
<script>
	Galleria.loadTheme('<?php echo base_url();?>assets/galleria/themes/classic/galleria.classic.min.js');
    Galleria.run('#gallery1');
    Galleria.run('#gallery2');
    Galleria.run('#gallery3');
</script>