<?php
/*
* H&L Partners Secure Files v1.0.0
* Author: Matt Johnson
* Description: Securely retrieves files stored outside the webroot
*/

$allowed_file_types = [
	"application/pdf",
	"application/msword",
	"application/vnd.openxmlformats-officedocument.wordprocessingml.document",
	"application/vnd.openxmlformats-officedocument.wordprocessingml.template",
	"application/vnd.ms-word.document.macroEnabled.12",
	"application/vnd.ms-word.template.macroEnabled.12",
	"text/plain",
	"text/richtext"

];

$path = "/home/handlp6/greenhorn/";
$file = $_GET["file"];

if( file_exists($path.$file) ){
	$file_info = new finfo(FILEINFO_MIME);
	$mime = $file_info->buffer(file_get_contents(realpath($path.$file)));
	$mime = strtok($mime,";");

	if( in_array($mime,$allowed_file_types) ){
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename=' . basename($file)); 
		header('Content-Transfer-Encoding: binary');
		header('Connection: Keep-Alive');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		header('Content-Length: ' . filesize(realpath($path.$file)));

    	readfile(realpath($path.$file));
    	exit;
	}
}

header("location:http://www.handlpartners.com/not-found");
exit;