
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.6.1/css/font-awesome.min.css">
<style>
#gs-wrap {margin:0px; padding:20px 20px 20px 0px;}
#gs-wrap h1 {margin:0px; padding:0px; position:relative;}
#gs-wrap table {border:#ccc 1px solid;}
#gs-wrap table thead tr {background:#ccc; border-bottom:#ccc 1px solid; font-weight:bold;}
#gs-wrap table tr {background:#fff; border-bottom:#ccc 1px solid;}	
#gs-wrap table tr:nth-child(even) {background:#eee;}
#gs-wrap table tr td {padding:0.6rem 0.8rem; vertical-align:top;}
#gs-wrap .row {margin:0px 0px 10px 0px; padding:0px; position:relative;}
#gs-wrap .download {background:#0073aa; color:#fff;}
#gs-wrap .right {position:absolute; top:0px; right:0px;}
#gs-wrap #gs-nav {margin:0px; padding:10px 0px 10px 0px;}
#gs-wrap #gs-nav .pager {cursor:default;}
#gs-wrap .wrap {margin:0px; padding:0px; max-height:100px; overflow-y:scroll;}
#gs-wrap .errors {background:#e14d43; color:#fff; font-weight:bold; padding:5px 10px;}
#gs-wrap .success {background:green; padding:10px;}
#gs-wrap .success input {margin:0px; width:100%; background:#eee; color:#000;}
</style>

<div id="gs-wrap">
	<div class="row">
		<h1>H&L Partners | Pardot KeyGen</h1>
		<p>When creating an email campaign in the Pardot system, use this utility to generate download URLs for white papers to allow for automatic login and download protection.</p>
		<p>Select the white paper you would like to link to along with the region to display the correct contact information.</p>
	</div>

	<?php if( !empty($errors) ): ?>
	<div class="row">
		<div class="errors">
			<ol>
				<?php foreach($errors as $err):?>
				<li><?php echo $err; ?></li>
				<?php endforeach;?>
			</ol>
		</div>
	</div>
	<?php endif; ?>

	<form method="post" action="">

	<div class="row">
		<h3>1) Select Your White Paper</h3>
		<select name="whitepaper">
			<option value="">-----</option>
			<?php foreach($papers as $paper):?>
			<option value="<?php echo $paper->id;?>" <?php if($paper->id == $selected) echo "selected='selected'"; ?>><?php echo $paper->title;?></option>
			<?php endforeach;?>
		</select>

		<h3>2) Select Your H&L Region</h3>
		<select name="region">
			<option value="">-----</option>
			<option value="west" <?php if($region === "west") echo "selected='selected'"; ?>>West Coast (Andrea Alfano)</option>
			<option value="east" <?php if($region === "east") echo "selected='selected'"; ?>>East Coast (Mark Schaeffer)</option>
		</select>

		<h3>3) Generate Access URL</h3>
		<input type="submit" name="submit" value="Generate" />
	</div>

	</form>

	<?php if( !empty($key) ): ?>
	<div class="row">
		<h3>Please use this URL in your email</h3>
		<div class="success">
			<input type="text" value="<?php echo $key;?>" />
		</div>
	</div>
	<?php endif; ?>
	
</div>