<?php

function hlp_get_campaigns(){
    $campaigns = array();

	$query 	= new WP_Query(array(
		'post_type' => 'hlp-campaigns',
        'post_status' => 'publish',
		'posts_per_page' => -1,
		'orderby' => 'menu_order',
		'order' => 'ASC',
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
            $query->the_post();
            $campaign = (object) array();
            $campaign->slug             = basename(get_the_permalink());
			$campaign->title            = types_render_field("campaign-title", array("output"=>"raw"));
            $campaign->description      = types_render_field("campaign-description", array("output"=>"raw"));
            $campaign->icons            = (object) array();
            $campaign->icons->square    = types_render_field("square-icon", array("output"=>"raw"));
            $campaign->icons->large     = types_render_field("large-icon", array("output"=>"raw"));

            $cid = wpcf_pr_post_get_belongs(get_the_ID(),"hlp-clients");
            $client = get_post($cid);

            $campaign->client = (object) array();
            $campaign->client->id = $cid;
            $campaign->client->slug = $client->post_name;
            $campaign->client->name = get_post_meta($cid,"wpcf-client-name",TRUE);
            $campaign->client->logo = get_post_meta($cid,"wpcf-client-logo",TRUE);

            $campaigns[] = $campaign;
		}
	}
	wp_reset_query();

    return $campaigns;
}

function hlp_filtered_projects($type=""){
    $projects = array();

    if( !empty($type) ){
        $args = array(
            'post_type'     => 'hlp-projects',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
            'nopaging'      => TRUE
        );
        if( !empty($_SESSION['media']) ){
            $args['tax_query'] = array(array('taxonomy' => 'media','field' => 'slug','terms' => $type));
        }
        $posts = get_posts($args);

        foreach($posts as $post){
            $project                    = (object) array();
            $project->id                = $post->ID;
            $project->slug              = $post->post_name;
            $project->title             = get_post_meta($post->ID,"wpcf-project-title",TRUE);
            $project->thumbnail         = get_post_meta($post->ID,"wpcf-project-thumbnail",TRUE);
            $project->photo             = get_post_meta($post->ID,"wpcf-project-photo",TRUE);
            $project->vimeo             = get_post_meta($post->ID,"wpcf-vimeo-id",TRUE);
            $project->iframe            = get_post_meta($post->ID,"wpcf-iframe-url",TRUE);
            $project->url               = get_post_meta($post->ID,"wpcf-external-url",TRUE);

            $client_id = wpcf_pr_post_get_belongs(get_the_ID(),"hlp-clients");
            $project->client            = get_post($client_id);

            $campaign_id = wpcf_pr_post_get_belongs(get_the_ID(),"hlp-campaigns");
            $project->campaign          = get_post($campaign_id);

            $projects[]                 = $project;
        }
    }

    return $projects;
}

//============================================================
// WORK BY MAJOR TYPE
//============================================================

function hlp_type_campaigns($type="",$client="",$campaign=""){
    $campaigns = array();

    if( !empty($type) ){
        $args = array(
            'post_type'     => 'hlp-clients',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
            'nopaging'      => TRUE
        );
        if( !empty($client) ){
            $args['ID'] = $client;
        }
        if( !empty($_SESSION['media']) ){
            $args['tax_query'] = array(array('taxonomy' => 'client-types','field' => 'slug','terms' => $type));
        }
        $clients = get_posts($args);

        foreach($clients as $client){
            $client_campaigns = hlp_client_campaigns($client->ID);
            $saved = array();
            foreach($client_campaigns as $camp){
                if( !empty($camp->projects) ){
                    $saved[] = $camp;
                }
            }
            $campaigns = array_merge($campaigns,$saved);
        }
    }

    return $campaigns;
}

function hlp_location_campaigns($id){
    $campaigns = array();

    if( !empty($id) ){
        $args = array(
            'post_type'     => 'hlp-campaigns',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
            'meta_query'    => array(array('key' => '_wpcf_belongs_hlp-locations_id','value' => $id)),
            'nopaging'      => TRUE
        );
        $posts = get_posts($args);

        foreach($posts as $post){
            $campaign                   = (object) array();
            $campaign->id               = $post->ID;
            $campaign->slug             = $post->post_name;
            $campaign->client           = hlp_get_client_by_id($id);
            $campaign->title            = get_post_meta($post->ID,"wpcf-campaign-title",TRUE);
            $campaign->description      = get_post_meta($post->ID,"wpcf-campaign-description",TRUE);
            $campaign->icons            = (object) array();
            $campaign->icons->square    = get_post_meta($post->ID,"wpcf-square-icon",TRUE);
            $campaign->icons->large     = get_post_meta($post->ID,"wpcf-large-icon",TRUE);
            $campaign->projects         = hlp_campaign_projects($campaign);
            $campaigns[]                = $campaign;
        }
    }

    return $campaigns;
}

//============================================================
// WORK BY LOCATION
//============================================================

function hlp_get_location_by_slug($slug=""){
    $location = FALSE;

    if( !empty($slug) ){
        $args = array(
            'post_type'     => 'hlp-locations',
            'post_status'   => 'publish',
            'numberposts'   => 1,
            'name'          => $slug
        );
        $query = new WP_Query($args);

        if( $query->have_posts() ){
            $client = array();
            while( $query->have_posts() ){
                $query->the_post();
                $location        = (object) array();
                $location->id    = get_the_ID();
                $location->slug  = basename(get_the_permalink());
                $location->name  = get_the_title();
            }
        }
        wp_reset_query();
    }

    return $location;
}

function hlp_client_campaign_single($client="",$campaign=""){
    $package = array();

    if( !empty($client) && !empty($campaign) ){
        $args = array(
            'ID'            => $campaign,
            'post_type'     => 'hlp-campaigns',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
            'meta_query'    => array(array('key' => '_wpcf_belongs_hlp-clients_id','value' => $client)),
            'nopaging'      => TRUE
        );
        $posts = get_posts($args);

        foreach($posts as $post){
            $package                   = (object) array();
            $package->id               = $post->ID;
            $package->slug             = $post->post_name;

            $package->client           = hlp_get_client_by_id($client);
            $package->title            = get_post_meta($post->ID,"wpcf-campaign-title",TRUE);
            $package->description      = get_post_meta($post->ID,"wpcf-campaign-description",TRUE);

            $package->icons            = (object) array();
            $package->icons->square    = get_post_meta($post->ID,"wpcf-square-icon",TRUE);
            $package->icons->large     = get_post_meta($post->ID,"wpcf-large-icon",TRUE);
            $package->projects         = hlp_campaign_projects($campaign);
        }
    }

    return $package;
}
