<?php
//============================================================
// Save Triggers
//============================================================

function hlp_format_project_title($pid=""){
    $title = "";
    if( !empty($pid) ){
        $campaign_id = wpcf_pr_post_get_belongs($pid,"hlp-campaigns");
        $campaign_name = get_post_meta($campaign_id,"wpcf-campaign-title",TRUE);
        $client_id = wpcf_pr_post_get_belongs($pid,"hlp-clients");
        $client_name = get_post_meta($client_id,"wpcf-client-name",TRUE);
        if( !empty($client_name) && !empty($campaign_name) ){
            $title = "$client_name - $campaign_name - ";
        }
    }
    return $title;
}

function hlp_format_campaign_title($cid=""){
    $title = "";
    if( !empty($cid) ){
        $client_id = wpcf_pr_post_get_belongs($cid,"hlp-clients");
        $client_name = get_post_meta($client_id,"wpcf-client-name",TRUE);
        if( !empty($client_name) ){
            $title = "$client_name - ";
        }
    }
    return $title;
}

function project_save($post_id,$post,$update){
	$id	= $_REQUEST['post_ID'];
	if('hlp-projects' !== $_POST['post_type']) return;

	remove_action('save_post','project_save',10,3);

	$slug = sanitize_title($_REQUEST['wpcf']['project-title']);

    $args = array("ID" => $id,"post_name" => $slug);
    $title = hlp_format_project_title($post_id);
    if( !empty($title) ) $args['post_title'] = $title . $_REQUEST['wpcf']['project-title'];
	wp_update_post($args);

	add_action('save_post','project_save',10,3);
}
add_action('save_post','project_save',10,3);

function campaign_save($post_id,$post,$update){
	$id	= $_REQUEST['post_ID'];
	if('hlp-campaigns' !== $_POST['post_type']) return;

	remove_action('save_post','campaign_save',10,3);

	$slug = sanitize_title($_REQUEST['wpcf']['campaign-title']);
    $args = array("ID" => $id,"post_name" => $slug);
    $title = hlp_format_campaign_title($post_id);
    if( !empty($title) ) $args['post_title'] = $title . $_REQUEST['wpcf']['campaign-title'];
	wp_update_post($args);

	add_action('save_post','campaign_save',10,3);
}
add_action('save_post','campaign_save',10,3);
