<?php
/**
* H&L Partners Work Functions
*
* @package WordPress
* @subpackage H&L Partners
* @since Version 1.0
*/

//============================================================
// Work Utilities
//============================================================

function hlp_get_mediums(){
    return array("broadcast","digital","print","non-trad");
}

//============================================================
// Work - Home Page
//============================================================

function hlp_get_current_campaigns(){
    $campaigns = array();

	$args = array(
		'post_type'   => 'hlp-campaigns',
        'post_status' => 'publish',
		'nopaging'    => TRUE,
		'orderby'     => 'rand'
	);
    $posts = get_posts($args);

	foreach($posts as $post){
        $projects = hlp_get_campaign_project_total($post->ID);

        if( $projects > 0 ){
            $campaign = (object) array();
            $campaign->id               = $post->ID;
            $campaign->slug             = $post->post_name;
    		$campaign->title            = get_post_meta($post->ID,"wpcf-campaign-title",TRUE);
            $campaign->description      = get_post_meta($post->ID,"wpcf-campaign-description",TRUE);

            $campaign->icons            = (object) array();
            $campaign->icons->square    = get_post_meta($post->ID,"wpcf-square-icon",TRUE);
            $campaign->icons->large     = get_post_meta($post->ID,"wpcf-large-icon",TRUE);

            $cid = wpcf_pr_post_get_belongs($post->ID,"hlp-clients");
            $client = get_post($cid);

            $campaign->client = (object) array();
            $campaign->client->id = $cid;
            $campaign->client->slug = $client->post_name;
            $campaign->client->name = get_post_meta($cid,"wpcf-client-name",TRUE);
            $campaign->client->logo = get_post_meta($cid,"wpcf-client-logo",TRUE);

            $campaigns[] = $campaign;
        }
	}

    if( !empty($campaigns) ){
        $data = array("campaigns" => $campaigns);
        return hlp_render_view("our-work/campaign-grid",$data);
    }

    return FALSE;
}

//============================================================
// Work - Office Pages
//============================================================

function hlp_get_offices(){
    $offices = array();

    $args = array(
		'post_type' => 'hlp-locations',
        'post_status' => 'publish',
		'posts_per_page' => -1,
		'orderby' => 'menu_order',
		'order' => 'ASC',
	);
    $posts = get_posts($args);

    foreach($posts as $post){
        $offices[] = $post->post_name;
    }

    return $offices;
}

function hlp_get_office_campaigns($office=""){
    $campaigns = array();
    $offices = hlp_get_offices();

    if( !empty($office) && in_array($office,$offices) ){
        $location = hlp_get_location_id($office);

        $args = array(
    		'post_type' => 'hlp-campaigns',
            'post_status' => 'publish',
    		'posts_per_page' => -1,
    		'orderby' => 'menu_order',
    		'order' => 'ASC',
            'meta_query'    => array(array('key' => '_wpcf_belongs_hlp-locations_id','value' => $location)),
    	);
        $posts = get_posts($args);

    	foreach($posts as $post){
            $campaign = (object) array();
            $campaign->id               = $post->ID;
            $campaign->slug             = $post->post_name;
    		$campaign->title            = get_post_meta($post->ID,"wpcf-campaign-title",TRUE);
            $campaign->description      = get_post_meta($post->ID,"wpcf-campaign-description",TRUE);

            $campaign->icons            = (object) array();
            $campaign->icons->square    = get_post_meta($post->ID,"wpcf-square-icon",TRUE);
            $campaign->icons->large     = get_post_meta($post->ID,"wpcf-large-icon",TRUE);

            $cid = wpcf_pr_post_get_belongs($post->ID,"hlp-clients");
            $client = get_post($cid);

            $campaign->client = (object) array();
            $campaign->client->id = $cid;
            $campaign->client->slug = $client->post_name;
            $campaign->client->name = get_post_meta($cid,"wpcf-client-name",TRUE);
            $campaign->client->logo = get_post_meta($cid,"wpcf-client-logo",TRUE);

            $campaigns[] = $campaign;
    	}
    }

    if( !empty($campaigns) ){
        $data = array("campaigns" => $campaigns);
        return hlp_render_view("our-work/campaign-grid",$data);
    }

    return FALSE;
}

//============================================================
// Work - Main Types
//============================================================

function hlp_get_clients(){
    $clients = array();

    $args = array(
		'post_type'   => 'hlp-projects',
        'post_status' => 'publish',
		'nopaging'    => TRUE,
		'orderby'     => 'menu_order',
		'order'       => 'ASC'
	);
	$posts = get_posts($args);

    foreach($posts as $post){
        $cid = wpcf_pr_post_get_belongs($post->ID,"hlp-clients");
        $slug = hlp_get_client_slug($cid);
        if( !empty($slug) && !in_array($slug,$clients) ) $clients[] = $slug;
	}

    return $clients;
}

function hlp_get_clients_by_type($type=""){
    $clients = array();

    if( !empty($type) ){
        $args = array(
    		'post_type'   => 'hlp-clients',
            'post_status' => 'publish',
    		'nopaging'    => TRUE,
    		'orderby'     => 'menu_order',
    		'order'       => 'ASC',
            'tax_query'   => array( array('taxonomy' => 'client-types','field' => 'slug','terms' => $type) )
    	);
    	$posts = get_posts($args);

        foreach($posts as $post){
            $clients[] = $post->post_name;
    	}
    }

    return $clients;
}

function hlp_get_client_ids_by_type($type=""){
    $clients = array();

    if( !empty($type) ){
        $args = array(
    		'post_type'   => 'hlp-clients',
            'post_status' => 'publish',
    		'nopaging'    => TRUE,
    		'orderby'     => 'menu_order',
    		'order'       => 'ASC',
            'tax_query'   => array( array('taxonomy' => 'client-types','field' => 'slug','terms' => $type) )
    	);
    	$posts = get_posts($args);

    	foreach($posts as $post){
            $clients[] = $post->ID;
    	}
    }

    return $clients;
}

function hlp_get_clients_by_media($media=""){
    $clients = array();

    if( !empty($media) ){
        $args = array(
    		'post_type'   => 'hlp-projects',
            'post_status' => 'publish',
    		'nopaging'    => TRUE,
    		'orderby'     => 'menu_order',
    		'order'       => 'ASC',
            'tax_query'   => array(array('taxonomy' => 'media','field' => 'slug','terms' => $media))
    	);
    	$posts = get_posts($args);

        foreach($posts as $post){
            $cid = wpcf_pr_post_get_belongs($post->ID,"hlp-clients");
            $clients[] = hlp_get_client_slug($cid);
    	}
    }

    if( !empty($clients) ){
        $clients = array_unique($clients);
    }

    return $clients;
}

function hlp_get_campaigns_by_type($type=""){
    $campaigns = array();

    if( !empty($type) ){
        $clients = hlp_get_client_ids_by_type($type);

        if( !empty($clients) ){
            $args = array(
                'post_type'     => 'hlp-campaigns',
                'post_status'   => 'publish',
                'orderby'       => 'menu_order',
                'order'         => 'ASC',
                'nopaging'      => TRUE,
                'meta_query'    => array(array('key' => '_wpcf_belongs_hlp-clients_id','value' => $clients,'compare' => 'IN'))
            );
            $posts = get_posts($args);

            foreach($posts as $post){
                $projects_total = hlp_get_campaign_project_total($post->ID);

                if($projects_total > 0){
                    $campaign                   = (object) array();
                    $campaign->id               = $post->ID;
                    $campaign->slug             = $post->post_name;
                    $campaign->title            = get_post_meta($post->ID,"wpcf-campaign-title",TRUE);
                    $campaign->description      = get_post_meta($post->ID,"wpcf-campaign-description",TRUE);

                    $campaign->icons            = (object) array();
                    $campaign->icons->square    = get_post_meta($post->ID,"wpcf-square-icon",TRUE);
                    $campaign->icons->large     = get_post_meta($post->ID,"wpcf-large-icon",TRUE);

                    $campaign->client            = (object) array();
                    $campaign->client->id        = wpcf_pr_post_get_belongs($campaign->id,"hlp-clients");
                    $campaign->client->slug      = hlp_get_client_slug($campaign->client->id);
                    $campaign->client->name      = get_post_meta($campaign->client->id,"wpcf-client-name",TRUE);
                    $campaign->client->logo      = get_post_meta($campaign->client->id,"wpcf-client-logo",TRUE);

                    $campaigns[]                = $campaign;
                }
            }
        }
    }

    if( !empty($campaigns) ){
        $data = array("campaigns" => $campaigns);
        return hlp_render_view("our-work/campaign-grid",$data);
    }

    return FALSE;
}

function hlp_get_client_home($slug=""){
    if( !empty($slug) ){
        $client = hlp_get_client_by_slug($slug,TRUE);
        if( !empty($client) ){
            $data = array("client" => $client);
            return hlp_render_view("our-work/client-viewer",$data);
        }
    }

    return FALSE;
}

function hlp_get_campaign_project_total($campaign_id=""){
    $total = 0;

    if( !empty($campaign_id) ){
        $args = array(
            'post_type'     => 'hlp-projects',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
            'nopaging'      => TRUE,
            'meta_query'    => array(array('key' => '_wpcf_belongs_hlp-campaigns_id','value' => $campaign_id))
        );
        $total = count( get_posts($args) );
    }

    return $total;
}

function hlp_get_all_projects_by_clients($clients,$current=""){
    $projects = array();
    $selected = "";
    $counter = 0;

    if( !empty($clients) ){
        foreach($clients as $client){
            $client_id = hlp_get_client_id($client);

            $args = array(
                'post_type'     => 'hlp-projects',
                'post_status'   => 'publish',
                'orderby'       => 'menu_order',
                'order'         => 'ASC',
                'meta_query'    => array(array('key' => '_wpcf_belongs_hlp-clients_id','value' => $client_id)),
                'nopaging'      => TRUE
            );

            //Automatic filtering for media type
            if( !empty($_SESSION['media']) ){
                $args['tax_query'] = array(array('taxonomy' => 'media','field' => 'slug','terms' => $_SESSION['media']));
            }

            $posts = get_posts($args);

            foreach($posts as $post){
                $project                    = (object) array();
                $project->index             = $counter;
                $project->id                = $post->ID;
                $project->slug              = $post->post_name;
                $project->title             = get_post_meta($post->ID,"wpcf-project-title",TRUE);
                $project->thumbnail         = get_post_meta($post->ID,"wpcf-project-thumbnail",TRUE);
                $project->photo             = get_post_meta($post->ID,"wpcf-project-photo",TRUE);
                $project->vimeo             = get_post_meta($post->ID,"wpcf-vimeo-id",TRUE);
                $project->iframe            = get_post_meta($post->ID,"wpcf-iframe-url",TRUE);
                $project->url               = get_post_meta($post->ID,"wpcf-external-url",TRUE);

                $project->campaign          = (object) array();
                $project->campaign->id      = wpcf_pr_post_get_belongs($project->id,"hlp-campaigns");
                $project->campaign->slug    = hlp_get_campaign_slug($project->campaign->id);
                $project->campaign->name    = get_post_meta($project->campaign->id,"wpcf-campaign-title",TRUE);
                $project->campaign->desc    = get_post_meta($project->campaign->id,"wpcf-campaign-description",TRUE);

                $project->client            = (object) array();
                $project->client->id        = $client_id;
                $project->client->slug      = hlp_get_client_slug($client_id);
                $project->client->name      = get_post_meta($project->client->id,"wpcf-client-name",TRUE);
                $project->client->logo      = get_post_meta($project->client->id,"wpcf-client-logo",TRUE);

                if( !empty($current) && $current === $project->slug ){
                    $selected = $project;
                }

                $projects[] = $project;
                $counter++;
            }
        }
    }

    if( !empty($current) && empty($selected) ) return FALSE;

    if( !empty($projects) ){
        $data = array("projects" => $projects,"selected" => $selected,"current" => $current);
        return hlp_render_view("our-work/campaign-viewer",$data);
    }

    return FALSE;
}

function hlp_get_all_projects_by_client($client="",$current=""){
    $projects = array();
    $selected = "";
    $counter = 0;

    if( !empty($client) ){
        $client_id = hlp_get_client_id($client);

        $args = array(
            'post_type'     => 'hlp-projects',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
            'nopaging'      => TRUE,
            'meta_query'    => array(array('key' => '_wpcf_belongs_hlp-clients_id','value' => $client_id))
        );

        //Automatic filtering for media type
        if( !empty($_SESSION['media']) ){
            $args['tax_query'] = array(array('taxonomy' => 'media','field' => 'slug','terms' => $_SESSION['media']));
        }

        $posts = get_posts($args);

        foreach($posts as $post){
            $project                    = (object) array();
            $project->index             = $counter;
            $project->id                = $post->ID;
            $project->slug              = $post->post_name;
            $project->title             = get_post_meta($post->ID,"wpcf-project-title",TRUE);
            $project->thumbnail         = get_post_meta($post->ID,"wpcf-project-thumbnail",TRUE);
            $project->photo             = get_post_meta($post->ID,"wpcf-project-photo",TRUE);
            $project->vimeo             = get_post_meta($post->ID,"wpcf-vimeo-id",TRUE);
            $project->iframe            = get_post_meta($post->ID,"wpcf-iframe-url",TRUE);
            $project->url               = get_post_meta($post->ID,"wpcf-external-url",TRUE);

            $project->campaign          = (object) array();
            $project->campaign->id      = wpcf_pr_post_get_belongs($project->id,"hlp-campaigns");
            $project->campaign->slug    = hlp_get_campaign_slug($project->campaign->id);
            $project->campaign->name    = get_post_meta($project->campaign->id,"wpcf-campaign-title",TRUE);
            $project->campaign->desc    = get_post_meta($project->campaign->id,"wpcf-campaign-description",TRUE);

            $project->client            = (object) array();
            $project->client->id        = $client_id;
            $project->client->slug      = hlp_get_client_slug($client_id);
            $project->client->name      = get_post_meta($project->client->id,"wpcf-client-name",TRUE);
            $project->client->logo      = get_post_meta($project->client->id,"wpcf-client-logo",TRUE);

            if( !empty($current) && $current === $project->slug ){
                $selected = $project;
            }

            $projects[] = $project;
            $counter++;
        }
    }

    if( !empty($current) && empty($selected) ) return FALSE;

    if( !empty($projects) ){
        $data = array("projects" => $projects,"selected" => $selected,"current" => $current);
        return hlp_render_view("our-work/campaign-viewer",$data);
    }

    return FALSE;
}

function hlp_get_all_projects_by_media($media="",$current=""){
    $projects = array();
    $selected = "";
    $counter = 0;

    if( !empty($media) ){
        $args = array(
            'post_type'     => 'hlp-projects',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
            'nopaging'      => TRUE,
            'tax_query'     => array(array('taxonomy' => 'media','field' => 'slug','terms' => $media))
        );

        $posts = get_posts($args);

        foreach($posts as $post){
            $project                    = (object) array();
            $project->index             = $counter;
            $project->id                = $post->ID;
            $project->slug              = $post->post_name;
            $project->title             = get_post_meta($post->ID,"wpcf-project-title",TRUE);
            $project->thumbnail         = get_post_meta($post->ID,"wpcf-project-thumbnail",TRUE);
            $project->photo             = get_post_meta($post->ID,"wpcf-project-photo",TRUE);
            $project->vimeo             = get_post_meta($post->ID,"wpcf-vimeo-id",TRUE);
            $project->iframe            = get_post_meta($post->ID,"wpcf-iframe-url",TRUE);
            $project->url               = get_post_meta($post->ID,"wpcf-external-url",TRUE);

            $project->campaign          = (object) array();
            $project->campaign->id      = wpcf_pr_post_get_belongs($project->id,"hlp-campaigns");
            $project->campaign->slug    = hlp_get_campaign_slug($project->campaign->id);
            $project->campaign->name    = get_post_meta($project->campaign->id,"wpcf-campaign-title",TRUE);
            $project->campaign->desc    = get_post_meta($project->campaign->id,"wpcf-campaign-description",TRUE);

            $project->client            = (object) array();
            $project->client->id        = wpcf_pr_post_get_belongs($project->id,"hlp-clients");
            $project->client->slug      = hlp_get_client_slug($client_id);
            $project->client->name      = get_post_meta($project->client->id,"wpcf-client-name",TRUE);
            $project->client->logo      = get_post_meta($project->client->id,"wpcf-client-logo",TRUE);

            if( !empty($current) && $current === $project->slug ){
                $selected = $project;
            }
            $projects[] = $project;
            $counter++;
        }
    }

    if( !empty($current) && empty($selected) ) return FALSE;

    if( !empty($projects) ){
        $data = array("projects" => $projects,"selected" => $selected,"current" => $current,"index" => $index);
        return hlp_render_view("our-work/campaign-viewer",$data);
    }

    return FALSE;
}

function hlp_get_all_projects_by_campaign($client="",$campaign="",$current=""){
    $projects = array();
    $selected = "";
    $counter = 0;

    if( !empty($client) && !empty($campaign) ){
        $client_id = hlp_get_client_id($client);
        $campaign_id = hlp_get_campaign_id($campaign);

        $args = array(
            'post_type'     => 'hlp-projects',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
            'nopaging'      => TRUE,
            'meta_query'    => array(
                array('key' => '_wpcf_belongs_hlp-clients_id','value' => $client_id),
                array('key' => '_wpcf_belongs_hlp-campaigns_id','value' => $campaign_id)
            )
        );

        //Automatic filtering for media type
        if( !empty($_SESSION['media']) ){
            $args['tax_query'] = array(array('taxonomy' => 'media','field' => 'slug','terms' => $_SESSION['media']));
        }

        $posts = get_posts($args);

        foreach($posts as $post){
            $project                    = (object) array();
            $project->index             = $counter;
            $project->id                = $post->ID;
            $project->slug              = $post->post_name;
            $project->title             = get_post_meta($post->ID,"wpcf-project-title",TRUE);
            $project->thumbnail         = get_post_meta($post->ID,"wpcf-project-thumbnail",TRUE);
            $project->photo             = get_post_meta($post->ID,"wpcf-project-photo",TRUE);
            $project->vimeo             = get_post_meta($post->ID,"wpcf-vimeo-id",TRUE);
            $project->iframe            = get_post_meta($post->ID,"wpcf-iframe-url",TRUE);
            $project->url               = get_post_meta($post->ID,"wpcf-external-url",TRUE);

            $project->campaign          = (object) array();
            $project->campaign->id      = $campaign_id;
            $project->campaign->slug    = hlp_get_campaign_slug($project->campaign->id);
            $project->campaign->name    = get_post_meta($project->campaign->id,"wpcf-campaign-title",TRUE);
            $project->campaign->desc    = get_post_meta($project->campaign->id,"wpcf-campaign-description",TRUE);

            $project->client            = (object) array();
            $project->client->id        = $client_id;
            $project->client->slug      = hlp_get_client_slug($client_id);
            $project->client->name      = get_post_meta($project->client->id,"wpcf-client-name",TRUE);
            $project->client->logo      = get_post_meta($project->client->id,"wpcf-client-logo",TRUE);

            if( !empty($current) && $current === $project->slug ){
                $selected = $project;
            }
            
            $projects[] = $project;
            $counter++;
        }
    }

    if( !empty($current) && empty($selected) ) return FALSE;

    if( !empty($projects) ){
        $data = array("projects" => $projects,"selected" => $selected,"current" => $current);
        return hlp_render_view("our-work/campaign-viewer",$data);
    }

    return FALSE;
}
