<?php
if( empty($selected) ){
    $selected = $projects[0];
    $current = $selected->slug;
}

$paths = array("our-work");
if( !empty($_SESSION["type"]) ) $paths[] = $_SESSION["type"];
if( !empty($_SESSION["media"]) ) $paths[] = $_SESSION["media"];
if( !empty($_SESSION["client"]) ) $paths[] = $_SESSION["client"];
if( !empty($_SESSION["campaign"]) ) $paths[] = $_SESSION["campaign"];
$paths = implode($paths,"/");

$previous = $selected->index - 1;
if($previous < 0) $previous = count($projects) - 1;
$prev_link = "/$paths/" . $projects[$previous]->slug;

$next = $selected->index + 1;
if($next === count($projects)) $next = 0;
$next_link = "/$paths/" . $projects[$next]->slug;
?>

<div id="work-campaign-viewer" class="clearfix">
    <div id="work-viewer-nav" class="clearfix">
        <a href="<?php echo $prev_link;?>" class="left"><i class="fa fa-arrow-circle-left"></i> Previous</a>
        <a href="<?php echo $next_link;?>" class="right">Next <i class="fa fa-arrow-circle-right"></i></a>
    </div>

    <div id="work-viewer-wrap">
        <?php if( !empty($selected->iframe) ): ?>
			<div id="work-viewer-frame" style="background-image:url(<?=$selected->photo;?>);" onclick="javascript:showIframe(this);" data-iframe="<?=$selected->iframe;?>"></div>
		<?php elseif( !empty($selected->photo) ): ?>
			<div id="work-viewer-frame" style="background-image:url(<?=$selected->photo;?>);" data-large="<?=$selected->photo;?>" onclick="javascript:showLightbox(this);"></div>
		<?php elseif( !empty($selected->vimeo) ): ?>
			<iframe src="//player.vimeo.com/video/<?=$selected->vimeo;?>?title=0&amp;byline=0&amp;portrait=0&amp;badge=0&amp;autoplay=0&amp;color=d6dc24" width="100%" height="100%" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
        <?php endif; ?>
	</div>

    <div id="work-viewer-info" class="clearfix">
        <div id="work-viewer-logo" style="background-image:url(<?php echo $selected->client->logo;?>);"></div>
        <div id="work-viewer-copy">
            <h1><?php echo $selected->campaign->name;?> : <?php echo $selected->title;?></h1>
            <?php echo $selected->campaign->desc;?>
            <?php if(!empty($selected->url)): ?><div class="ext-link"><a href="<?php echo @$selected->url;?>" target="_blank">View the Website</a></div><?php endif;?>

            <?php
                if( empty($_SESSION["campaign"]) ):
                    $link = array("our-work");
                    if( !empty($_SESSION["client"]) ){
                        $link[] = $_SESSION["client"];
                    } else {
                        $link[] = $selected->client->slug;
                    }
                    if( !empty($_SESSION["campaign"]) ){
                        $link[] = $_SESSION["campaign"];
                    } else {
                        $link[] = $selected->campaign->slug;
                    }
                    $link[] = $selected->slug;
                    $link = implode($link,"/");
            ?>
            <a href="/<?php echo $link;?>/" class="campaign-link">View The Full Campaign</a>
            <?php endif; ?>
        </div>
    </div>

    <div id="work-viewer-projects" class="clearfix">
        <div id="work-viewer-inner" class="clearfix">
            <div class="row small-up-2 medium-up-4 large-up-5">
            <?php
                foreach($projects as $project):
                $active = ($project->slug === $current) ? "selected" : "";
            ?>

                <div class="column">
                    <a href="/<?php echo $paths;?>/<?php echo @$project->slug;?>/" class="proj square <?php echo $active;?>" style="background-image:url(<?php echo $project->thumbnail;?>);">
                		<span class="tile-title"><b><?php echo @$project->client->name;?></b><br><?php echo @$project->title;?></span>
                		<span class="tile-corner">
                			<img src="<?php echo get_template_directory_uri(); ?>/assets/img/hl_plus_rollover_green.png">
                		</span>
                        <div class="tile-screen"></div>
                	</a>
                </div>

            <?php endforeach; ?>
            </div>
        </div>
    </div>

    <?php if( count($projects) > 5 ): ?>
        <div id="work-viewer-more">View More</div>
    <?php endif; ?>
</div>

<script>
jQuery(document).ready(function(){
    jQuery("#work-viewer-more").on("click",function(){
        if( jQuery(this).hasClass("active") ){
            jQuery(this).removeClass("active").html("VIEW MORE");
            jQuery("#work-viewer-projects").animate({height:"160px"},500,"swing");
        } else {
            jQuery(this).addClass("active").html("VIEW LESS");
            var wH = jQuery("#work-viewer-inner").height();
            jQuery("#work-viewer-projects").animate({height:wH + "px"},500,"swing");
        }
    });

    jQuery("#work-viewer-wrap").animate({opacity:1},1000,"swing");

    var dly = 500;
    jQuery(".proj").each(function(index,elem){
        jQuery(elem).delay(dly).animate({opacity:1},750,"swing");
        dly += 50;
    });
});
</script>
