<?php
/**
 * Template Name: What We Do - Franchise Retail
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since H&L Partners 1.0
 */

get_header();
hlp_load_functions("models");
?>

<?php
$banner = types_render_field("banner-image",array("output"=>"raw"));
if(!empty($banner)):
?>
<div id="page-banner" style="background-image:url(<?php echo $banner;?>);"></div>
<?php endif;?>

<?php
while(have_posts()):
    the_post();
    the_content();
endwhile;
?>

<div id="page-related-cases" class="case-study-grid row small-up-1 medium-up-2 large-up-3">
    <?php hlp_case_studies("franchise-retail",3); ?>
</div>

<div id="page-related-news" class="row gray">
    <div class="small-12 columns">
        <div id="news-excerpts">
        <h2>Related News</h2>
        <?php hlp_get_news_by_category("retail",3); ?>
        </div>
    </div>
</div>

<?php get_footer();
