<?php
/**
 * Template Name: What We Do - Viewpoint Pardot Landing
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since H&L Partners 1.0
 */

$auth = FALSE;
if( isset($_SESSION["pardot-auth"]) && !empty($_SESSION["pardot-auth"]) ) $auth = TRUE;

add_filter('the_content','wpautop');
hlp_load_functions("models");

$mode 		= get_query_var("display_mode");
$data 		= get_query_var("pardot_data");
$office 	= get_query_var("pardot_office");
$paper 		= hlp_gozone_details($data);
$banner 	= "/wp-content/uploads/2016/02/ALT_Header.jpg";
$download 	= "";

if( empty($auth) ) hlp_redirect_to("/what-we-do/viewpoint/{$data}");
if( empty($paper) ) hlp_redirect_404();
if( !empty($paper) && !empty($paper->image) ) $banner = $paper->image;

if( isset($paper->email_download) && !empty($paper->email_download) ){
	$download = $paper->email_download;
}
else if( isset($paper->download) && !empty($paper->download) ){
	$download = $paper->download;
}

get_header();
?>

<?php if(!empty($banner)): ?>
<div id="page-banner" style="background-image:url(<?php echo $banner;?>);"></div>
<?php endif;?>

<div id="gozone-single">
	<div class="row">
	        <div class="small-12 columns">
				<h1>Thank you for your interest in our White Paper:</h1>
	            <h2 class="green" style="font-size:1.4rem; line-height:1.2;"><?php echo $paper->title; ?></h2>
	        </div>
	</div>

	<?php if( !empty($download) ): ?>

	<div class="row noimg">
	        <div class="small-12 columns">
				<br/>
				<p>Your download will begin shortly...</p>

				<script>
                jQuery(document).ready(function(){
                    window.setTimeout(function(){
                        window.location = "<?php echo @$download;?>";
                    },3000);
                });
            	</script>
	        </div>
	</div>

	<?php else: ?>

	<div class="row noimg">
	        <div class="small-12 columns">
				<br/>
				<p><strong>The selected white paper is currently unavailable</strong></p>
	        </div>
	</div>

	<?php endif; ?>

	<div class="row noimg">
	        <div class="small-12 columns">
				<p>In the sections below you may also find interesting and relevant papers on different aspects of effective retail advertising beneficial to helping you
				with your marketing challenges. And if you would like to speak with someone live to learn more about H&amp;L Partners expertise
				in Retail/Franchise advertising, or just want to pick our brains, feel free to contact:</p>

				<?php if($office === "east"): ?>
					<p>Mark Schaeffer, <a href="tel:314-454-3400">314-454-3400</a> or <a href="mailto:mschaeffer@handlpartners.com">mschaeffer@handlpartners.com</a></p>
				<?php else: ?>
					<p>Andrea Alfano, <a href="tel:415-434-8500">415-434-8500</a> or <a href="mailto:andreaalfano@handlpartners.com">andreaalfano@handlpartners.com</a></p>
				<?php endif; ?>
	        </div>
	</div>

</div>

<div id="gozone-tabs" class="clearfix">
    <div id="gozone-tab-left" class="tablink active">
        <div class="tab">Retail/Franchise</div>
        <div class="tab-tri"></div>
    </div>
    <div id="gozone-tab-right" class="tablink">
        <div class="tab-tri"></div>
        <div class="tab">Destination Travel</div>
    </div>
</div>

<div id="gozone-contents" class="clearfix">
    <div id="gozone-contents-left" class="tabbox">
        <?php hlp_gozone("franchise-retail"); ?>
    </div>
    <div id="gozone-contents-right" class="tabbox" style="display:none">
        <?php hlp_gozone("destination-travel"); ?>
    </div>
</div>

<script>
    jQuery(document).ready(function(){
        jQuery(".tablink").on("click",function(){
            jQuery(".tablink").removeClass("active");
            jQuery(this).addClass("active");
            jQuery(".tabbox").hide();
            jQuery(".tabbox").eq(jQuery(this).index()).fadeIn("fast");
        });
    });
</script>

<?php get_footer();
