<?php
add_filter('the_content','wpautop');

if( have_posts() ): while( have_posts() ): the_post();

$categories = get_the_terms($post->ID,'case-study-categories');
if(!empty($categories)) $category = $categories[0]->slug;
else $category = "franchise-retail";

$attachment = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
$banner = @$attachment[0];
if(empty($banner)) $banner = "/wp-content/uploads/2016/02/header3.jpg";

$pardot     = types_render_field("pardot-post-url", array("output"=>"raw"));
$download 	= types_render_field("white-paper-download", array("output"=>"raw"));
$errors     = "";

$slug = basename(get_the_permalink());
$pardot_success = urlencode("http://www.handlpartners.com/pardot?slug={$slug}&complete=1");
$pardot_errors = urlencode("http://www.handlpartners.com/pardot?slug={$slug}&complete=0");

$firstname = hlp_get_input("firstname","get","");
$lastname = hlp_get_input("lastname","get","");
$company = hlp_get_input("title","get","");
$company = hlp_get_input("company","get","");
$email = hlp_get_input("email","get","");

if( isset($_GET["errors"]) &&  $_GET["errors"] === "true" ){
    $errors = "Please enter all required fields";
}
else if( isset($_GET["success"]) &&  $_GET["success"] === "true" ){
	$_SESSION["pardot-auth"] = 1;
	@session_commit();
    hlp_redirect_to("/what-we-do/viewpoint-thank-you/{$slug}");
}

get_header();
?>

<!-- <?php var_dump($category); ?> //-->

<style>
#viewpoint-form input[type='text'] {padding-top:3px; padding-bottom:3px; height:auto;}
#viewpoint-form input.hlbtn {width:100%; font-size:1.1rem; padding:16px 0px; margin-top:5px;}
#viewpoint-quote {color:#D6DC24; font-size:1.75rem; font-style:italic; text-align:left; padding-bottom:10px; line-height:1.2;}
</style>

<div id="page-banner" style="background-image:url(<?php echo $banner;?>);"></div>

<div id="gozone-single">
    <?php if( !empty($errors) ): ?>
        <div class="row errors">
            <div class="small-12 columns">
                <?php echo $errors;?>
            </div>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="small-12 columns">
            <h1><?php the_title(); ?></h1>
        </div>
    </div>

    <div class="row">
        <?php if( !empty($pardot) ): ?>

        <div class="small-12 medium-8 large-8 columns">
			<?php
				$pullquote = types_render_field("white-paper-quote", array("output"=>"raw"));
				if( !empty($pullquote) ):
			?>
			<div id="viewpoint-quote">&ldquo;<?php echo $pullquote; ?>&rdquo;</div>
			<?php endif; ?>
            <?php echo types_render_field("white-paper-details", array("output"=>"html")); ?>
        </div>
        <div class="small-12 medium-4 large-4 columns">
            <?php if( isset($_SESSION["pardot-auth"]) && !empty($_SESSION["pardot-auth"]) ): ?>

            <div style="margin:10px 0px 0px 0px; background:#5F6062; color:#fff; padding:20px;">
                <p>Thank you for registering, to download this white paper please click the button below.</p>
                <p style="text-align:center;"><a href="/what-we-do/viewpoint-thank-you/<?php echo @$slug;?>" class="hlbtn">DOWNLOAD</a></p>
            </div>

            <?php else: ?>

            <form id="viewpoint-form" method="post" action="<?php echo $pardot;?>?success_location=<?php echo $pardot_success;?>&error_location=<?php echo $pardot_errors;?>" class="clearfix">
                <input type="hidden" name="slug" value="<?php echo @$slug;?>" />
				<div style="text-align:center; color:#D6DC24; text-transform:uppercase; padding-bottom:10px;">White Paper Download</div>
                <label>
                    First Name: <span class="lime">*</span>
                    <input type="text" name="firstname" value="<?php echo @$firstname;?>" required />
                </label>
                <label>
                    Last Name: <span class="lime">*</span>
                    <input type="text" name="lastname" value="<?php echo @$lastname;?>" required />
                </label>
                <label>
                    Title:
                    <input type="text" name="title" value="<?php echo @$title;?>" />
                </label>
                <label>
                    Company:
                    <input type="text" name="company" value="<?php echo @$company;?>" />
                </label>
                <label>
                    Email: <span class="lime">*</span>
                    <input type="text" name="email" value="<?php echo @$email;?>" required />
                </label>
                <label>
                    <input class="hlbtn" type="submit" name="submit-action" value="DOWNLOAD NOW" />
                </label>
            </form>

            <?php endif;?>
        </div>

        <?php else: ?>

        <div class="small-12 columns">
            <?php echo types_render_field("white-paper-details", array("output"=>"html")); ?>
        </div>

        <?php endif; ?>
    </div>
</div>

<br/>

<!--
<div id="page-related-news" class="row gray">
    <div class="small-12 columns">
        <div id="news-excerpts">
        <h2>Related News</h2>
        <?php hlp_get_news_by_category("mixed",3); ?>
        </div>
    </div>
</div>
//-->

<div id="gozone-tabs" class="clearfix">
    <div id="gozone-tab-left" class="tablink <?php echo $category === 'franchise-retail' ? 'active' : ''; ?>">
        <div class="tab">Retail/Franchise</div>
        <div class="tab-tri"></div>
    </div>
    <div id="gozone-tab-right" class="tablink <?php echo $category === 'franchise-retail' ? '' : 'active'; ?>">
        <div class="tab-tri"></div>
        <div class="tab">Destination Travel</div>
    </div>
</div>

<div id="gozone-contents" class="clearfix">
    <div id="gozone-contents-left" class="tabbox">
        <?php hlp_gozone("franchise-retail"); ?>
    </div>
    <div id="gozone-contents-right" class="tabbox" style="display:none">
        <?php hlp_gozone("destination-travel"); ?>
    </div>
</div>

<script>
    jQuery(document).ready(function(){
        jQuery(".tablink").on("click",function(){
            jQuery(".tablink").removeClass("active");
            jQuery(this).addClass("active");
            jQuery(".tabbox").hide();
            jQuery(".tabbox").eq(jQuery(this).index()).fadeIn("fast");
        });
    });
</script>

<?php
endwhile;
endif;
get_footer();
